/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModMaterials;
import erebus.ModTabs;
import erebus.client.model.armor.ModelArmorGlider;
import erebus.client.model.armor.ModelArmorPowered;
import erebus.core.handler.KeyBindingHandler;
import erebus.items.ItemMaterials;
import erebus.network.server.PacketGlider;
import erebus.network.server.PacketGliderPowered;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemArmorGlider
extends ItemArmor {
    public ItemArmorGlider() {
        super(ModMaterials.ARMOR_REIN_EXOSKELETON, 2, EntityEquipmentSlot.CHEST);
        this.func_77637_a(ModTabs.GEAR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        if (this.canFly()) {
            list.add(new TextComponentTranslation("tooltip.erebus.poweredglider", new Object[0]).func_150254_d());
            list.add(new TextComponentTranslation("tooltip.erebus.gliderpoweredkey", new Object[0]).func_150254_d() + ": " + Keyboard.getKeyName((int)KeyBindingHandler.POWERED_GLIDE.func_151463_i()));
        }
        list.add(new TextComponentTranslation("tooltip.erebus.gliderglidekey", new Object[0]).func_150254_d() + ": " + Keyboard.getKeyName((int)KeyBindingHandler.GLIDE.func_151463_i()));
    }

    public boolean func_82816_b_(ItemStack stack) {
        return !stack.func_77942_o() ? false : (!stack.func_77978_p().func_150297_b("display", 10) ? false : stack.func_77978_p().func_74775_l("display").func_150297_b("color", 3));
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return 0xFFFFFF;
        }
        NBTTagCompound displayNBT = nbt.func_74775_l("display");
        return displayNBT == null ? 0xFFFFFF : (displayNBT.func_150297_b("color", 3) ? displayNBT.func_74762_e("color") : 0xFFFFFF);
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound displayNBT;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && (displayNBT = nbt.func_74775_l("display")).func_74764_b("color")) {
            displayNBT.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int colour) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        NBTTagCompound displayNBT = nbt.func_74775_l("display");
        if (!nbt.func_150297_b("display", 10)) {
            nbt.func_74782_a("display", (NBTBase)displayNBT);
        }
        displayNBT.func_74768_a("color", colour);
    }

    public boolean func_82789_a(ItemStack armour, ItemStack material) {
        return material.func_77973_b() == ModItems.MATERIALS && material.func_77952_i() == ItemMaterials.EnumErebusMaterialsType.GLIDER_WING.ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack is, Entity entity, EntityEquipmentSlot armorSlot, String type) {
        return "erebus:textures/models/armor/glider.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase player, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped modelBiped) {
        if (this.canFly()) {
            ModelArmorPowered model = new ModelArmorPowered();
            model.field_78116_c.field_78806_j = false;
            model.field_178720_f.field_78806_j = false;
            model.field_78115_e.field_78806_j = false;
            model.field_178723_h.field_78806_j = false;
            model.field_178724_i.field_78806_j = false;
            model.field_178721_j.field_78806_j = false;
            model.field_178722_k.field_78806_j = false;
            if (stack.func_77942_o()) {
                model.isGliding = stack.func_77978_p().func_74767_n("isGliding");
                model.isPowered = stack.func_77978_p().func_74767_n("isPowered");
            }
            return model;
        }
        ModelArmorGlider model = new ModelArmorGlider();
        model.field_78116_c.field_78806_j = false;
        model.field_178720_f.field_78806_j = false;
        model.field_78115_e.field_78806_j = false;
        model.field_178723_h.field_78806_j = false;
        model.field_178724_i.field_78806_j = false;
        model.field_178721_j.field_78806_j = false;
        model.field_178722_k.field_78806_j = false;
        if (stack.func_77942_o()) {
            model.isGliding = stack.func_77978_p().func_74767_n("isGliding");
        }
        return model;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (stack.func_77978_p().func_74767_n("isGliding") && (!KeyBindingHandler.GLIDE.func_151470_d() || entity.field_70122_E)) {
                stack.func_77978_p().func_74757_a("isGliding", false);
                Erebus.NETWORK_WRAPPER.sendToServer((IMessage)new PacketGlider(false));
            }
            if (this.canFly() && stack.func_77978_p().func_74767_n("isPowered") && (!KeyBindingHandler.POWERED_GLIDE.func_151470_d() || entity.field_70122_E)) {
                stack.func_77978_p().func_74757_a("isPowered", false);
                Erebus.NETWORK_WRAPPER.sendToServer((IMessage)new PacketGliderPowered(false));
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.func_77663_a(stack, world, (Entity)player, 0, false);
        player.field_70143_R = 0.0f;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        ItemStack fuel = this.findFuel(player);
        if (nbt.func_74767_n("isGliding") && !player.field_70122_E) {
            player.field_70159_w *= 1.05;
            player.field_70179_y *= 1.05;
            player.field_70181_x *= 0.5;
        }
        if (nbt.func_74767_n("isPowered") && this.canFly() && this.hasFuelOrIsCreative(player) && !player.field_70122_E) {
            player.field_70159_w *= 1.05;
            player.field_70179_y *= 1.05;
            player.field_70181_x += 0.1;
            if (!player.field_71075_bZ.field_75098_d) {
                nbt.func_74768_a("fuelTicks", nbt.func_74762_e("fuelTicks") + 1);
                if (nbt.func_74762_e("fuelTicks") >= 80) {
                    nbt.func_74768_a("fuelTicks", 0);
                    fuel.func_190918_g(1);
                    if (fuel.func_190916_E() == 0) {
                        player.field_71071_by.func_184437_d(fuel);
                    }
                }
            }
        }
    }

    private boolean hasFuelOrIsCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || !this.findFuel(player).func_190926_b();
    }

    private ItemStack findFuel(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isGem(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isGem(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.RED_GEM);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("isGliding", false);
        stack.func_77978_p().func_74757_a("isPowered", false);
        stack.func_77978_p().func_74768_a("fuelTicks", 0);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderPre(RenderPlayerEvent.Pre event) {
        GlStateManager.func_179094_E();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack chestPlate = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (!chestPlate.func_190926_b() && chestPlate.func_77973_b() instanceof ItemArmorGlider && chestPlate.func_77942_o() && (chestPlate.func_77978_p().func_74767_n("isGliding") && !player.field_70122_E || chestPlate.func_77978_p().func_74767_n("isPowered") && !player.field_70122_E)) {
            float yaw = player.field_70177_z;
            float x1 = (float)Math.cos(Math.PI * (double)yaw / 180.0);
            float y1 = (float)Math.sin(Math.PI * (double)yaw / 180.0);
            GlStateManager.func_179114_b((float)60.0f, (float)x1, (float)0.0f, (float)y1);
            player.field_70721_aZ = 0.1f;
        }
    }

    public boolean canFly() {
        return this == ModItems.GLIDER_CHESTPLATE_POWERED;
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        GlStateManager.func_179121_F();
    }
}

