/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.items.block.ItemBlockEnum;
import erebus.world.feature.plant.WorldGenGiantFlowers;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlantedGiantFlower
extends BlockBush
implements IGrowable,
ModBlocks.IHasCustomItem,
ModBlocks.ISubBlocksBlock {
    public static final PropertyEnum<EnumFlowerType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumFlowerType.class);
    protected static final AxisAlignedBB FLOWER_AABB = new AxisAlignedBB(0.21875, 0.0, 0.21875, 0.78125, 0.625, 0.78125);

    public BlockPlantedGiantFlower() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149715_a(0.5f);
        this.func_149647_a(ModTabs.PLANTS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumFlowerType.FLOWER_WHITE)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.FLOWER_SEED;
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.PLANTS) {
            for (EnumFlowerType type : EnumFlowerType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumFlowerType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumFlowerType type = (EnumFlowerType)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState soil = world.func_180495_p(pos.func_177977_b());
            return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return this.canSustainFlower(world.func_180495_p(pos.func_177977_b()));
    }

    protected boolean canSustainFlower(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(world, rand, pos, state);
            }
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int meta = this.func_176201_c(state);
        WorldGenGiantFlowers worldGen = new WorldGenGiantFlowers();
        if (meta >= 0 && meta <= 13) {
            worldGen.setFlowerColor(meta);
        }
        if (meta == 14) {
            worldGen.setFlowerColor(rand.nextInt(14), rand.nextInt(14));
        }
        world.func_175698_g(pos);
        if (!worldGen.func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumFlowerType.values()[meta])), 3);
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        return ItemBlockEnum.create((Block)this, EnumFlowerType.class);
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (EnumFlowerType type : EnumFlowerType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum EnumFlowerType implements IErebusEnum
    {
        FLOWER_BLACK,
        FLOWER_RED,
        FLOWER_BROWN,
        FLOWER_BLUE,
        FLOWER_PURPLE,
        FLOWER_CYAN,
        FLOWER_LIGHT_GRAY,
        FLOWER_GRAY,
        FLOWER_PINK,
        FLOWER_YELLOW,
        FLOWER_LIGHT_BLUE,
        FLOWER_MAGENTA,
        FLOWER_ORANGE,
        FLOWER_WHITE,
        FLOWER_RAINBOW;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.PLANTED_FLOWER, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

