/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.handler.darksteel.DarkSteelTooltipManager;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import crazypants.enderio.base.item.darksteel.DarkShieldRenderer;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.anvil.AnvilUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.ClientUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelShield
extends ItemShield
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IOverlayRenderAware,
IHaveRenderers,
AnvilUpgrade.INoAnvilUpgrade {
    private static final String DOT_COM = ".name";
    @Nonnull
    private final IEquipmentData data;
    @Nonnull
    private static final UUID uuid1 = UUID.nameUUIDFromBytes("ItemDarkSteelShield".getBytes());
    @Nonnull
    private static final UUID uuid2 = UUID.nameUUIDFromBytes("ItemDarkSteelShield2".getBytes());

    public static ItemDarkSteelShield createDarkSteel(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemDarkSteelShield(EquipmentData.DARK_STEEL, modObject);
    }

    public static ItemDarkSteelShield createEndSteel(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemDarkSteelShield(EquipmentData.END_STEEL, modObject);
    }

    public static ItemDarkSteelShield createStelar(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemDarkSteelShield(EquipmentData.STELLAR_ALLOY, modObject);
    }

    protected ItemDarkSteelShield(@Nonnull IEquipmentData data, @Nonnull IModObject modobject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77656_e(data.getShieldDurability());
        this.data = data;
        modobject.apply(this);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        if (stack.func_179543_a("BlockEntityTag") != null) {
            EnumDyeColor enumdyecolor = TileEntityBanner.func_190616_d((ItemStack)stack);
            return EnderIO.lang.localizeExact(this.func_77667_c(stack) + "." + enumdyecolor.func_176762_d() + DOT_COM);
        }
        return EnderIO.lang.localizeExact(this.func_77667_c(stack) + DOT_COM);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return false;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return this.data;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 6;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)this.data.getRepairIngotOredict());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            list.add((Object)is);
        }
    }

    public void setDamage(@Nonnull ItemStack stack, int damageNew) {
        int damage = damageNew - this.getDamage(stack);
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (damage > 0 && eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * this.getPowerPerDamagePoint(stack), false);
            eu.writeToItem();
        } else {
            super.setDamage(stack, damageNew);
        }
    }

    protected int getPowerPerDamagePoint(@Nonnull ItemStack stack) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null) {
            return eu.getCapacity() / this.data.getShieldDurability();
        }
        return 1;
    }

    @Nonnull
    protected ItemArmor.ArmorMaterial getMaterial(@Nonnull ItemStack stack) {
        return EnergyUpgradeManager.getEnergyStored(stack) > 0 ? this.data.getArmorMaterialEmpowered() : this.data.getArmorMaterial();
    }

    public int getItemEnchantability(@Nonnull ItemStack stack) {
        return this.getMaterial(stack).func_78045_a();
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelTooltipManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelTooltipManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            // empty if block
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        DarkSteelTooltipManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.OFFHAND;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHIELD_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHIELD_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHIELD_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHIELD_ABSORPTION_RATIO;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ClientUtil.registerDefaultItemRenderer(modObject);
        this.setTileEntityItemStackRenderer(DarkShieldRenderer.INSTANCE);
    }

    public boolean isShield(@Nonnull ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND || equipmentSlot == EntityEquipmentSlot.OFFHAND) {
            ItemArmor.ArmorMaterial armorMaterial = this.getMaterial(stack);
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(uuid1, "Shield toughness", (double)armorMaterial.func_189416_e(), 0));
            multimap.put((Object)EntityLivingBase.SWIM_SPEED.func_111108_a(), (Object)new AttributeModifier(uuid2, "Shield swimming", -0.5, 2));
            for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
                if (!upgrade.hasUpgrade(stack)) continue;
                upgrade.addAttributeModifiers(equipmentSlot, stack, (Multimap<String, AttributeModifier>)multimap);
            }
        }
        return multimap;
    }
}

