/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.util;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.ModConfig;
import com.elenai.elenaidodge2.api.DodgeEvent;
import com.elenai.elenaidodge2.capability.absorption.AbsorptionProvider;
import com.elenai.elenaidodge2.capability.absorption.IAbsorption;
import com.elenai.elenaidodge2.capability.dodges.DodgesProvider;
import com.elenai.elenaidodge2.capability.dodges.IDodges;
import com.elenai.elenaidodge2.effects.ServerDodgeEffects;
import com.elenai.elenaidodge2.event.ClientTickEventListener;
import com.elenai.elenaidodge2.gui.DodgeGui;
import com.elenai.elenaidodge2.network.PacketHandler;
import com.elenai.elenaidodge2.network.message.CDodgeEffectsMessage;
import com.elenai.elenaidodge2.network.message.CFeatherFailureMessage;
import com.elenai.elenaidodge2.network.message.CInitPlayerMessage;
import com.elenai.elenaidodge2.network.message.CUpdateConfigMessage;
import com.elenai.elenaidodge2.network.message.CVelocityMessage;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Utils {
    public static void setPlayerVelocity(double x, double y, double z, EntityPlayer player) {
        PacketHandler.instance.sendTo((IMessage)new CVelocityMessage(x, y, z), (EntityPlayerMP)player);
    }

    public static void cancelledByFeathers(EntityPlayer player) {
        PacketHandler.instance.sendTo((IMessage)new CFeatherFailureMessage(), (EntityPlayerMP)player);
    }

    public static void handleDodge(DodgeEvent.Direction direction, DodgeEvent.ServerDodgeEvent event, EntityPlayerMP player) {
        double motionZ;
        double motionX;
        double f = event.getForce();
        switch (direction) {
            case LEFT: {
                motionX = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                motionZ = -((double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                break;
            }
            case RIGHT: {
                motionX = -((double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                motionZ = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                break;
            }
            case FORWARD: {
                motionX = (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                motionZ = (double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f;
                break;
            }
            case BACK: {
                motionX = -((double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                motionZ = -((double)(MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)0.017453294f)) * f);
                break;
            }
            default: {
                motionX = 0.0;
                motionZ = 0.0;
                ElenaiDodge2.LOG.error("DodgeEvent Posted and Received but no direction given!");
            }
        }
        Utils.setPlayerVelocity(motionX, ModConfig.common.balance.verticality, motionZ, (EntityPlayer)player);
        ServerDodgeEffects.run(player);
        IDodges d = (IDodges)player.getCapability(DodgesProvider.DODGES_CAP, null);
        IAbsorption a = (IAbsorption)player.getCapability(AbsorptionProvider.ABSORPTION_CAP, null);
        PacketHandler.instance.sendTo((IMessage)new CDodgeEffectsMessage(d.getDodges(), a.getAbsorption()), player);
    }

    public static double calculateForce(EntityPlayer player) {
        return ModConfig.common.balance.force;
    }

    public static void initPlayer(EntityPlayer player) {
        PacketHandler.instance.sendTo((IMessage)new CInitPlayerMessage(20), (EntityPlayerMP)player);
        IDodges d = (IDodges)player.getCapability(DodgesProvider.DODGES_CAP, null);
        d.set(20);
    }

    public static void updateClientConfig(EntityPlayerMP player) {
        IDodges d = (IDodges)player.getCapability(DodgesProvider.DODGES_CAP, null);
        IAbsorption a = (IAbsorption)player.getCapability(AbsorptionProvider.ABSORPTION_CAP, null);
        PacketHandler.instance.sendTo((IMessage)new CUpdateConfigMessage(ModConfig.common.feathers.rate, d.getDodges(), Utils.arrayToString(ModConfig.common.weights.weights), ModConfig.common.feathers.half, a.getAbsorption()), player);
    }

    public static void updateClientConfig() {
        PacketHandler.instance.sendToAll((IMessage)new CUpdateConfigMessage(ModConfig.common.feathers.rate, 9999, Utils.arrayToString(ModConfig.common.weights.weights), ModConfig.common.feathers.half, 9999));
    }

    public static int getTotalEnchantmentLevel(Enchantment enchantment, EntityLivingBase entity) {
        List iterable = enchantment.func_185260_a(entity);
        if (iterable == null) {
            return 0;
        }
        int i = 0;
        for (ItemStack itemstack : iterable) {
            int j = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemstack);
            i += j;
        }
        return i;
    }

    public static String arrayToString(String[] string) {
        if (string.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String n : string) {
                stringBuilder.append("").append(n.replace("'", "\\'")).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        return "";
    }

    public static void showDodgeBar() {
        if (DodgeGui.alpha < 1.0f) {
            DodgeGui.alpha = 1.0f;
            ClientTickEventListener.alpha = ClientTickEventListener.alphaLen;
        }
    }
}

