/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.network.message;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.api.DodgeEvent;
import com.elenai.elenaidodge2.util.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class SDodgeMessage
implements IMessage {
    private boolean messageValid;
    private String dir;

    public SDodgeMessage() {
        this.messageValid = false;
    }

    public SDodgeMessage(String dir) {
        this.dir = dir;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.dir = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge2.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dir);
    }

    public static class Handler
    implements IMessageHandler<SDodgeMessage, IMessage> {
        public IMessage onMessage(SDodgeMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.SERVER) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(SDodgeMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            DodgeEvent.ServerDodgeEvent event = new DodgeEvent.ServerDodgeEvent(DodgeEvent.Direction.valueOf(message.dir), Utils.calculateForce((EntityPlayer)player), (EntityPlayer)player);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                Utils.handleDodge(DodgeEvent.Direction.valueOf(message.dir), event, player);
            }
        }
    }
}

