/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.network.message;

import com.elenai.elenaidodge2.ElenaiDodge2;
import com.elenai.elenaidodge2.ModConfig;
import com.elenai.elenaidodge2.util.ClientStorage;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class CInitPlayerMessage
implements IMessage {
    private int dodges;
    private boolean messageValid;

    public CInitPlayerMessage() {
        this.messageValid = false;
    }

    public CInitPlayerMessage(int dodges) {
        this.dodges = dodges;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.dodges = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge2.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.dodges);
    }

    public static class Handler
    implements IMessageHandler<CInitPlayerMessage, IMessage> {
        public IMessage onMessage(CInitPlayerMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(CInitPlayerMessage message, MessageContext ctx) {
            ClientStorage.dodges = message.dodges;
            if (ModConfig.client.hud.tutorial) {
                ClientStorage.shownTutorial = false;
                ClientStorage.tutorialDodges = 0.0;
            }
        }
    }
}

