/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge2.api;

import com.elenai.elenaidodge2.api.SpendFeatherEvent;
import com.elenai.elenaidodge2.capability.absorption.AbsorptionProvider;
import com.elenai.elenaidodge2.capability.absorption.IAbsorption;
import com.elenai.elenaidodge2.capability.dodges.DodgesProvider;
import com.elenai.elenaidodge2.capability.dodges.IDodges;
import com.elenai.elenaidodge2.capability.regen.IRegen;
import com.elenai.elenaidodge2.capability.regen.RegenProvider;
import com.elenai.elenaidodge2.capability.weight.IWeight;
import com.elenai.elenaidodge2.capability.weight.WeightProvider;
import com.elenai.elenaidodge2.network.PacketHandler;
import com.elenai.elenaidodge2.network.message.CUpdateDodgeMessage;
import com.elenai.elenaidodge2.network.message.CUpdateRegenMessage;
import com.elenai.elenaidodge2.util.ClientStorage;
import com.elenai.elenaidodge2.util.Utils;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FeathersHelper {
    public int getFeatherLevel(EntityPlayerMP player) {
        IDodges d = (IDodges)player.getCapability(DodgesProvider.DODGES_CAP, null);
        return d.getDodges();
    }

    public int getFeatherLevel(EntityPlayerSP player) {
        return ClientStorage.dodges;
    }

    public void increaseFeathers(EntityPlayerMP player, int amount) {
        IDodges d = (IDodges)player.getCapability(DodgesProvider.DODGES_CAP, null);
        if (d.getDodges() + amount <= 20) {
            d.increase(amount);
        } else {
            d.set(20);
        }
        PacketHandler.instance.sendTo((IMessage)new CUpdateDodgeMessage(d.getDodges()), player);
        Utils.showDodgeBar();
    }

    public void decreaseFeathers(EntityPlayerMP player, int amount) {
        SpendFeatherEvent event = new SpendFeatherEvent(amount, (EntityPlayer)player);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            IAbsorption a = (IAbsorption)player.getCapability(AbsorptionProvider.ABSORPTION_CAP, null);
            IDodges d = (IDodges)player.getCapability(DodgesProvider.DODGES_CAP, null);
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                if (a.getAbsorption() <= 0) {
                    d.set(d.getDodges() - event.getCost());
                } else if (a.getAbsorption() - event.getCost() >= 0) {
                    a.set(a.getAbsorption() - event.getCost());
                } else {
                    d.increase(a.getAbsorption() - event.getCost());
                    a.set(0);
                }
            }
            if (d.getDodges() < 0) {
                d.set(0);
            }
            PacketHandler.instance.sendTo((IMessage)new CUpdateDodgeMessage(d.getDodges()), player);
            Utils.showDodgeBar();
        }
    }

    public int getWeight(EntityPlayerMP player) {
        IWeight w = (IWeight)player.getCapability(WeightProvider.WEIGHT_CAP, null);
        return w.getWeight();
    }

    public int getWeight(EntityPlayerSP player) {
        return ClientStorage.weight;
    }

    public void setRegenModifier(EntityPlayerMP player, int modifier) {
        IRegen r = (IRegen)player.getCapability(RegenProvider.REGEN_CAP, null);
        r.set(modifier);
        PacketHandler.instance.sendTo((IMessage)new CUpdateRegenMessage(r.getRegen()), player);
    }

    public void increaseRegenModifier(EntityPlayerMP player, int modifier) {
        IRegen r = (IRegen)player.getCapability(RegenProvider.REGEN_CAP, null);
        r.increase(modifier);
        PacketHandler.instance.sendTo((IMessage)new CUpdateRegenMessage(r.getRegen()), player);
    }

    public void decreaseRegenModifier(EntityPlayerMP player, int modifier) {
        IRegen r = (IRegen)player.getCapability(RegenProvider.REGEN_CAP, null);
        r.decrease(modifier);
        PacketHandler.instance.sendTo((IMessage)new CUpdateRegenMessage(r.getRegen()), player);
    }

    public int getRegenModifier(EntityPlayerSP player) {
        IRegen r = (IRegen)player.getCapability(RegenProvider.REGEN_CAP, null);
        return r.getRegen();
    }
}

