/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityRemnant;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenObelisk
extends WorldGenSurfaceStructure {
    private static final String SPAWNER_DATA_BLOCK_TAG = "spawner";
    private static final ResourceLocation REMNANT_ID = new ResourceLocation("ebwizardry", "remnant");

    @Override
    public String getStructureName() {
        return "obelisk";
    }

    @Override
    public long getRandomSeedModifier() {
        return 19348242L;
    }

    @Override
    public Mirror[] getValidMirrors() {
        return new Mirror[]{Mirror.NONE};
    }

    @Override
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Wizardry.settings.obeliskDimensions, (int)world.field_73011_w.getDimension()) && Wizardry.settings.obeliskRarity > 0 && random.nextInt(Wizardry.settings.obeliskRarity) == 0;
    }

    @Override
    public ResourceLocation getStructureFile(Random random) {
        return Wizardry.settings.obeliskFiles[random.nextInt(Wizardry.settings.obeliskFiles.length)];
    }

    @Override
    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        ITemplateProcessor processor = (w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockRunestone ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a(BlockRunestone.ELEMENT, (Comparable)((Object)element)), i.field_186244_c) : i;
        template.func_189960_a(world, origin, processor, settings, 18);
        WizardryAntiqueAtlasIntegration.markObelisk(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            if (((String)entry.getValue()).equals(SPAWNER_DATA_BLOCK_TAG)) {
                BlockPos pos = (BlockPos)entry.getKey();
                world.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityMobSpawner) {
                    MobSpawnerBaseLogic spawnerLogic = ((TileEntityMobSpawner)world.func_175625_s(pos)).func_145881_a();
                    EntityRemnant remant = new EntityRemnant(world);
                    remant.setElement(element);
                    remant.setBoundOrigin(pos);
                    NBTTagCompound entityTag = new NBTTagCompound();
                    entityTag.func_74778_a("id", REMNANT_ID.toString());
                    remant.func_70014_b(entityTag);
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74782_a("Entity", (NBTBase)entityTag);
                    spawnerLogic.func_184993_a(new WeightedSpawnerEntity(nbt));
                    continue;
                }
                Wizardry.logger.info("Tried to set the mob spawned by an obelisk, but the expected TileEntityMobSpawner was not present");
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }
}

