/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityZombieSpawner;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ZombieApocalypse
extends SpellConstruct<EntityZombieSpawner> {
    public static final String MINION_SPAWN_INTERVAL = "minion_spawn_interval";
    private static final int SPAWNER_HEIGHT = 8;
    private static final int MIN_SPAWNER_HEIGHT = 3;

    public ZombieApocalypse() {
        super("zombie_apocalypse", SpellActions.POINT_UP, EntityZombieSpawner::new, false);
        this.addProperties("minion_lifetime", MINION_SPAWN_INTERVAL);
        this.soundValues(1.3f, 1.0f, 0.0f);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    @Override
    protected boolean spawnConstruct(World world, double x, double y, double z, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        Integer ceiling = BlockUtils.getNearestSurface(world, new BlockPos(x, y + 3.0, z), EnumFacing.UP, 5, false, BlockUtils.SurfaceCriteria.COLLIDABLE.flip());
        y = ceiling == null ? (y += 8.0) : (double)ceiling.intValue() - 0.5;
        return super.spawnConstruct(world, x, y, z, side, caster, modifiers);
    }

    @Override
    protected void addConstructExtras(EntityZombieSpawner construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        construct.spawnHusks = caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)caster, WizardryItems.charm_minion_variants);
    }

    @Override
    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y + 8.0, z, 0, (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
    }
}

