/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumAction;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class SpellThrowable<T extends EntityThrowable>
extends Spell {
    public static final String DAMAGE_MODIFIER_NBT_KEY = "ebwizardryDamageModifier";
    private static final float LAUNCH_Y_OFFSET = 0.1f;
    protected final BiFunction<World, EntityLivingBase, T> projectileFactory;

    public SpellThrowable(String name, BiFunction<World, EntityLivingBase, T> projectileFactory) {
        this("ebwizardry", name, projectileFactory);
    }

    public SpellThrowable(String modID, String name, BiFunction<World, EntityLivingBase, T> projectileFactory) {
        super(modID, name, EnumAction.NONE, false);
        this.projectileFactory = projectileFactory;
        this.addProperties("range");
        this.npcSelector((e, o) -> true);
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    protected float calculateVelocity(SpellModifiers modifiers, float launchHeight) {
        float g = 0.03f;
        float range = this.getProperty("range").floatValue() * modifiers.get(WizardryItems.range_upgrade);
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            float velocity = this.calculateVelocity(modifiers, caster.func_70047_e() - 0.1f);
            EntityThrowable projectile = (EntityThrowable)this.projectileFactory.apply(world, (EntityLivingBase)caster);
            projectile.func_184538_a((Entity)caster, caster.field_70125_A, caster.field_70177_z, 0.0f, velocity, 1.0f);
            projectile.getEntityData().func_74776_a(DAMAGE_MODIFIER_NBT_KEY, modifiers.get("potency"));
            this.addProjectileExtras(projectile, (EntityLivingBase)caster, modifiers);
            world.func_72838_d((Entity)projectile);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        caster.func_184609_a(hand);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target != null) {
            if (!world.field_72995_K) {
                float velocity = this.calculateVelocity(modifiers, caster.func_70047_e() - 0.1f);
                EntityThrowable projectile = (EntityThrowable)this.projectileFactory.apply(world, (EntityLivingBase)caster);
                int aimingError = caster instanceof ISpellCaster ? ((ISpellCaster)caster).getAimingError(world.func_175659_aa()) : EntityUtils.getDefaultAimingError(world.func_175659_aa());
                this.aim(projectile, (EntityLivingBase)caster, (Entity)target, velocity, aimingError);
                this.addProjectileExtras(projectile, (EntityLivingBase)caster, modifiers);
                world.func_72838_d((Entity)projectile);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    private void aim(T throwable, EntityLivingBase caster, Entity target, float speed, float aimingError) {
        ((EntityThrowable)throwable).field_184539_c = caster;
        ((EntityThrowable)throwable).field_70163_u = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.1f;
        double dx = target.field_70165_t - caster.field_70165_t;
        double dy = !throwable.func_189652_ae() ? target.field_70163_u + (double)(target.field_70131_O / 3.0f) - ((EntityThrowable)throwable).field_70163_u : target.field_70163_u + (double)(target.field_70131_O / 2.0f) - ((EntityThrowable)throwable).field_70163_u;
        double dz = target.field_70161_v - caster.field_70161_v;
        double horizontalDistance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        if (horizontalDistance >= 1.0E-7) {
            double dxNormalised = dx / horizontalDistance;
            double dzNormalised = dz / horizontalDistance;
            throwable.func_70107_b(caster.field_70165_t + dxNormalised, ((EntityThrowable)throwable).field_70163_u, caster.field_70161_v + dzNormalised);
            float bulletDropCompensation = !throwable.func_189652_ae() ? (float)horizontalDistance * 0.2f : 0.0f;
            throwable.func_70186_c(dx, dy + (double)bulletDropCompensation, dz, speed, aimingError);
        }
    }

    protected void addProjectileExtras(T projectile, EntityLivingBase caster, SpellModifiers modifiers) {
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        float damageModifier;
        if (event.getSource().func_76364_f() != null && !(event.getSource() instanceof IElementalDamage) && (damageModifier = event.getSource().func_76364_f().getEntityData().func_74760_g(DAMAGE_MODIFIER_NBT_KEY)) > 0.0f) {
            DamageSource newSource;
            Entity projectile = event.getSource().func_76364_f();
            Entity shooter = event.getSource().func_76346_g();
            DamageSource damageSource = newSource = shooter == projectile ? MagicDamage.causeDirectMagicDamage(projectile, MagicDamage.DamageType.MAGIC) : MagicDamage.causeIndirectMagicDamage(projectile, shooter, MagicDamage.DamageType.MAGIC);
            if (event.getSource().func_94541_c()) {
                newSource.func_94540_d();
            }
            if (event.getSource().func_76347_k()) {
                newSource.func_76361_j();
            }
            if (event.getSource().func_76352_a()) {
                newSource.func_76349_b();
            }
            DamageSafetyChecker.attackEntitySafely(event.getEntity(), newSource, event.getAmount() * damageModifier, event.getSource(), true);
        }
    }
}

