/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Reversal
extends SpellRay {
    public static final String REVERSED_EFFECTS = "reversed_effects";

    public Reversal() {
        super("reversal", SpellActions.POINT, false);
        this.addProperties(REVERSED_EFFECTS);
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && target instanceof EntityLivingBase) {
            List negativePotions = new ArrayList<PotionEffect>(caster.func_70651_bq());
            negativePotions.removeIf(p -> !p.func_188419_a().func_76398_f());
            if (!world.field_72995_K) {
                if (negativePotions.isEmpty()) {
                    return false;
                }
                int bonusEffects = (int)((modifiers.get("potency") - 1.0f) / 0.15f + 0.5f) - 1;
                int n = this.getProperty(REVERSED_EFFECTS).intValue() + bonusEffects;
                Collections.shuffle(negativePotions);
                negativePotions = negativePotions.subList(0, negativePotions.size() < n ? negativePotions.size() : n);
                negativePotions.forEach(p -> caster.func_184589_d(p.func_188419_a()));
                negativePotions.forEach(arg_0 -> ((EntityLivingBase)((EntityLivingBase)target)).func_70690_d(arg_0));
            } else {
                ParticleBuilder.create(ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(1.0f, 1.0f, 0.3f).spawn(world);
            }
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.1f, 0.0f, 0.0f).spawn(world);
        ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(0.1f, 0.0f, 0.05f).spawn(world);
    }
}

