/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class LightningPulse
extends Spell {
    public static final String REPULSION_VELOCITY = "repulsion_velocity";

    public LightningPulse() {
        super("lightning_pulse", SpellActions.POINT_DOWN, false);
        this.addProperties("effect_radius", "damage", REPULSION_VELOCITY);
        this.soundValues(2.0f, 1.0f, 0.0f);
    }

    @Override
    protected SoundEvent[] createSounds() {
        return this.createSoundsWithSuffixes("spark", "explosion");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70122_E) {
            List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
            for (EntityLivingBase target : targets) {
                if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target)) continue;
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.SHOCK), this.getProperty("damage").floatValue() * modifiers.get("potency"));
                if (world.field_72995_K) continue;
                double dx = target.field_70165_t - caster.field_70165_t;
                double dz = target.field_70161_v - caster.field_70161_v;
                double vectorLength = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                target.field_70159_w = (double)this.getProperty(REPULSION_VELOCITY).floatValue() * (dx /= vectorLength);
                target.field_70181_x = 0.0;
                target.field_70179_y = (double)this.getProperty(REPULSION_VELOCITY).floatValue() * (dz /= vectorLength);
                if (!(target instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
            }
            if (world.field_72995_K) {
                ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING_PULSE).pos(caster.field_70165_t, caster.field_70163_u + 0.005, caster.field_70161_v).scale(modifiers.get(WizardryItems.blast_upgrade)).spawn(world);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }
}

