/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityIceSpike;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstructRanged;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.block.state.IBlockProperties;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class IceSpikes
extends SpellConstructRanged<EntityIceSpike> {
    public static final String ICE_SPIKE_COUNT = "ice_spike_count";

    public IceSpikes() {
        super("ice_spikes", EntityIceSpike::new, true);
        this.addProperties("effect_radius", ICE_SPIKE_COUNT, "damage", "effect_duration", "effect_strength");
        this.ignoreUncollidables(true);
    }

    @Override
    protected boolean spawnConstruct(World world, double x, double y, double z, EnumFacing side, EntityLivingBase caster, SpellModifiers modifiers) {
        if (side == null) {
            return false;
        }
        BlockPos blockHit = new BlockPos(x, y, z);
        if (side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            blockHit = blockHit.func_177972_a(side);
        }
        if (world.func_180495_p(blockHit).func_185915_l()) {
            return false;
        }
        Vec3d origin = new Vec3d(x, y, z);
        Vec3d pos = origin.func_178787_e(new Vec3d(side.func_176734_d().func_176730_m()));
        super.spawnConstruct(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, side, caster, modifiers);
        int quantity = (int)(this.getProperty(ICE_SPIKE_COUNT).floatValue() * modifiers.get(WizardryItems.blast_upgrade)) - 1;
        float maxRadius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        for (int i = 0; i < quantity; ++i) {
            Integer surface;
            double radius = 0.5 + world.field_73012_v.nextDouble() * ((double)maxRadius - 0.5);
            Vec3d offset = Vec3d.func_189986_a((float)(world.field_73012_v.nextFloat() * 180.0f - 90.0f), (float)(world.field_73012_v.nextBoolean() ? 0.0f : 180.0f)).func_186678_a(radius).func_178785_b(side.func_185119_l() * (float)Math.PI / 180.0f).func_178789_a(GeometryUtils.getPitch(side) * (float)Math.PI / 180.0f);
            if (side.func_176740_k().func_176722_c()) {
                offset = offset.func_178785_b(1.5707964f);
            }
            if ((surface = BlockUtils.getNearestSurface(world, new BlockPos(origin.func_178787_e(offset)), side, (int)maxRadius, true, BlockUtils.SurfaceCriteria.basedOn(IBlockProperties::func_185915_l))) == null) continue;
            Vec3d vec = GeometryUtils.replaceComponent(origin.func_178787_e(offset), side.func_176740_k(), (double)surface.intValue()).func_178788_d(new Vec3d(side.func_176730_m()));
            super.spawnConstruct(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, side, caster, modifiers);
        }
        return true;
    }

    @Override
    protected void addConstructExtras(EntityIceSpike construct, EnumFacing side, EntityLivingBase caster, SpellModifiers modifiers) {
        construct.lifetime = 30 + construct.field_70170_p.field_73012_v.nextInt(15);
        construct.setFacing(side);
    }
}

