/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class HealAlly
extends SpellRay {
    public HealAlly() {
        super("heal_ally", SpellActions.POINT, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
        this.addProperties("health");
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving(target)) {
            EntityLivingBase entity = (EntityLivingBase)target;
            if (entity.func_110143_aJ() < entity.func_110138_aP() && entity.func_110143_aJ() > 0.0f) {
                entity.func_70691_i(this.getProperty("health").floatValue() * modifiers.get("potency"));
                if (world.field_72995_K) {
                    ParticleBuilder.spawnHealParticles(world, entity);
                }
                this.playSound(world, entity, ticksInUse, -1, modifiers, new String[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

