/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.construct.EntityIceBarrier;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class FrostBarrier
extends Spell {
    private static final double BARRIER_DISTANCE = 2.0;
    private static final double BARRIER_ARC_RADIUS = 10.0;
    private static final double BARRIER_SPACING = 1.4;

    public FrostBarrier() {
        super("frost_barrier", SpellActions.SUMMON, false);
        this.npcSelector((e, o) -> true);
        this.addProperties("duration");
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean requiresPacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70122_E) {
            if (!this.createBarriers(world, caster.func_174791_d(), caster.func_70040_Z(), (EntityLivingBase)caster, modifiers)) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (caster.field_70122_E) {
            if (!this.createBarriers(world, caster.func_174791_d(), target.func_174791_d().func_178788_d(caster.func_174791_d()), (EntityLivingBase)caster, modifiers)) {
                return false;
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!this.createBarriers(world, new Vec3d(x, y, z), new Vec3d(direction.func_176730_m()), null, modifiers)) {
            return false;
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    private boolean createBarriers(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            direction = GeometryUtils.horizontalise(direction);
            Vec3d centre = origin.func_178787_e(direction.func_186678_a(-8.0));
            ArrayList<EntityIceBarrier> barriers = new ArrayList<EntityIceBarrier>();
            int barrierCount = 1 + Math.max(1, (int)((modifiers.get("potency") - 1.0f) / 0.15f + 0.5f));
            for (int i = 0; i < barrierCount; ++i) {
                EntityIceBarrier barrier = this.createBarrier(world, centre, direction.func_178785_b(0.14f * (float)i), caster, modifiers, barrierCount, i);
                if (barrier != null) {
                    barriers.add(barrier);
                }
                if (i == 0 || (barrier = this.createBarrier(world, centre, direction.func_178785_b(-0.14f * (float)i), caster, modifiers, barrierCount, i)) == null) continue;
                barriers.add(barrier);
            }
            if (barriers.isEmpty()) {
                return false;
            }
            barriers.forEach(arg_0 -> ((World)world).func_72838_d(arg_0));
        }
        return true;
    }

    private EntityIceBarrier createBarrier(World world, Vec3d centre, Vec3d direction, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int barrierCount, int index) {
        Vec3d position = centre.func_178787_e(direction.func_186678_a(10.0));
        Integer floor = BlockUtils.getNearestFloor(world, new BlockPos(position), 3);
        if (floor == null) {
            return null;
        }
        position = GeometryUtils.replaceComponent(position, EnumFacing.Axis.Y, (double)floor.intValue());
        float scale = 1.5f - (float)index / (float)barrierCount * 0.5f;
        double yOffset = 1.5 * (double)scale;
        EntityIceBarrier barrier = new EntityIceBarrier(world);
        barrier.func_70107_b(position.field_72450_a, position.field_72448_b - yOffset, position.field_72449_c);
        barrier.setCaster(caster);
        barrier.lifetime = (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
        barrier.damageMultiplier = modifiers.get("potency");
        barrier.func_70101_b((float)Math.toDegrees(MathHelper.func_181159_b((double)(-direction.field_72450_a), (double)direction.field_72449_c)), barrier.field_70125_A);
        barrier.setSizeMultiplier(scale);
        barrier.setDelay(1 + 3 * index);
        if (!world.func_72872_a(barrier.getClass(), barrier.func_174813_aQ().func_72317_d(0.0, yOffset, 0.0)).isEmpty()) {
            return null;
        }
        return barrier;
    }
}

