/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.entity.living.EntityDecoy;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class Decoy
extends Spell {
    public static final String DECOY_LIFETIME = "decoy_lifetime";
    public static final String MOB_TRICK_CHANCE = "mob_trick_chance";

    public Decoy() {
        super("decoy", SpellActions.SUMMON, false);
        this.soundValues(1.0f, 0.9f, 0.2f);
        this.addProperties(DECOY_LIFETIME, MOB_TRICK_CHANCE);
    }

    @Override
    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double splitSpeed = caster.func_145782_y() % 2 == 0 ? 0.3 : -0.3;
        this.spawnDecoy(world, (EntityLivingBase)caster, modifiers, splitSpeed);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        double splitSpeed = world.field_73012_v.nextBoolean() ? 0.3 : -0.3;
        this.spawnDecoy(world, (EntityLivingBase)caster, modifiers, splitSpeed);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    private void spawnDecoy(World world, EntityLivingBase caster, SpellModifiers modifiers, double splitSpeed) {
        if (!world.field_72995_K) {
            EntityDecoy decoy = new EntityDecoy(world);
            decoy.setCaster(caster);
            decoy.setLifetime(this.getProperty(DECOY_LIFETIME).intValue());
            decoy.func_70012_b(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, caster.field_70177_z, caster.field_70125_A);
            decoy.func_70024_g(-caster.func_70040_Z().field_72449_c * splitSpeed, 0.0, caster.func_70040_Z().field_72450_a * splitSpeed);
            if (caster instanceof EntityPlayer) {
                decoy.func_96094_a(caster.func_70005_c_());
            }
            world.func_72838_d((Entity)decoy);
            for (EntityLiving creature : EntityUtils.getEntitiesWithinRadius(16.0, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world, EntityLiving.class)) {
                if (creature.func_70638_az() != caster || !(world.field_73012_v.nextFloat() < this.getProperty(MOB_TRICK_CHANCE).floatValue() * modifiers.get("potency"))) continue;
                creature.func_70624_b((EntityLivingBase)decoy);
            }
        }
        caster.func_70024_g(caster.func_70040_Z().field_72449_c * splitSpeed, 0.0, -caster.func_70040_Z().field_72450_a * splitSpeed);
    }
}

