/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.packet;

import electroblob.wizardry.Settings;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Tier;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncSettings
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> PacketSyncSettings.copySettings(message));
        }
        return null;
    }

    private static void copySettings(Message message) {
        Wizardry.settings.discoveryMode = message.settings.discoveryMode;
        Wizardry.settings.creativeBypassesArcaneLock = message.settings.creativeBypassesArcaneLock;
        Wizardry.settings.slowTimeAffectsPlayers = message.settings.slowTimeAffectsPlayers;
        Wizardry.settings.replaceVanillaFireballs = message.settings.replaceVanillaFireballs;
        Wizardry.settings.replaceVanillaFallDamage = message.settings.replaceVanillaFallDamage;
        Wizardry.settings.forfeitChance = message.settings.forfeitChance;
        Wizardry.settings.progressionRequirements = message.settings.progressionRequirements;
        Wizardry.settings.bookshelfSearchRadius = message.settings.bookshelfSearchRadius;
        Wizardry.settings.bookshelfBlocks = message.settings.bookshelfBlocks;
        Wizardry.settings.bookItems = message.settings.bookItems;
        Wizardry.settings.passiveMobsAreAllies = message.settings.passiveMobsAreAllies;
    }

    public static class Message
    implements IMessage {
        public Settings settings;

        public Message() {
        }

        public Message(Settings settings) {
            this.settings = settings;
        }

        public void fromBytes(ByteBuf buf) {
            this.settings = new Settings();
            this.settings.discoveryMode = buf.readBoolean();
            this.settings.creativeBypassesArcaneLock = buf.readBoolean();
            this.settings.slowTimeAffectsPlayers = buf.readBoolean();
            this.settings.replaceVanillaFireballs = buf.readBoolean();
            this.settings.replaceVanillaFallDamage = buf.readBoolean();
            this.settings.forfeitChance = buf.readFloat();
            this.settings.progressionRequirements = new int[Tier.values().length - 1];
            for (int i = 0; i < this.settings.progressionRequirements.length; ++i) {
                this.settings.progressionRequirements[i] = buf.readInt();
            }
            this.settings.bookshelfSearchRadius = buf.readInt();
            this.settings.bookshelfBlocks = Message.readMetaItems(buf);
            this.settings.bookItems = Message.readMetaItems(buf);
            this.settings.passiveMobsAreAllies = buf.readBoolean();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.settings.discoveryMode);
            buf.writeBoolean(this.settings.creativeBypassesArcaneLock);
            buf.writeBoolean(this.settings.slowTimeAffectsPlayers);
            buf.writeBoolean(this.settings.replaceVanillaFireballs);
            buf.writeBoolean(this.settings.replaceVanillaFallDamage);
            buf.writeFloat((float)this.settings.forfeitChance);
            for (int i = 0; i < this.settings.progressionRequirements.length; ++i) {
                buf.writeInt(this.settings.progressionRequirements[i]);
            }
            buf.writeInt(this.settings.bookshelfSearchRadius);
            Message.writeMetaItems(buf, this.settings.bookshelfBlocks);
            Message.writeMetaItems(buf, this.settings.bookItems);
            buf.writeBoolean(this.settings.passiveMobsAreAllies);
        }

        private static Pair<ResourceLocation, Short>[] readMetaItems(ByteBuf buf) {
            int length = buf.readInt();
            ArrayList<Pair> entries = new ArrayList<Pair>();
            for (int i = 0; i < length; ++i) {
                entries.add(Pair.of((Object)new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)), (Object)buf.readShort()));
            }
            return entries.toArray(new Pair[0]);
        }

        private static void writeMetaItems(ByteBuf buf, Pair<ResourceLocation, Short>[] items) {
            buf.writeInt(items.length);
            for (Pair<ResourceLocation, Short> entry : items) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((ResourceLocation)entry.getLeft()).toString());
                buf.writeShort((int)((Short)entry.getRight()).shortValue());
            }
        }
    }
}

