/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import com.google.common.collect.Streams;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityIceBarrier;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.integration.baubles.WizardryBaublesIntegration;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.registry.WizardryTabs;
import electroblob.wizardry.spell.Banish;
import electroblob.wizardry.spell.CurseOfSoulbinding;
import electroblob.wizardry.spell.Disintegration;
import electroblob.wizardry.spell.GreaterHeal;
import electroblob.wizardry.spell.Heal;
import electroblob.wizardry.spell.HealAlly;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.MindControl;
import electroblob.wizardry.spell.Resurrection;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellConjuration;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemArtefact
extends Item {
    private final EnumRarity rarity;
    private final Type type;
    private boolean enabled = true;

    public ItemArtefact(EnumRarity rarity, Type type) {
        this.func_77625_d(1);
        this.func_77637_a(WizardryTabs.GEAR);
        this.rarity = rarity;
        this.type = type;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public Type getType() {
        return this.type;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.rarity == EnumRarity.EPIC;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
        if (!this.enabled) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return WizardryBaublesIntegration.enabled() ? new WizardryBaublesIntegration.ArtefactBaubleProvider(this.type) : null;
    }

    public static boolean isArtefactActive(EntityPlayer player, Item artefact) {
        if (!(artefact instanceof ItemArtefact)) {
            throw new IllegalArgumentException("Not an artefact!");
        }
        if (!((ItemArtefact)artefact).enabled) {
            return false;
        }
        if (WizardryBaublesIntegration.enabled()) {
            return WizardryBaublesIntegration.isBaubleEquipped(player, artefact);
        }
        return InventoryUtils.getPrioritisedHotbarAndOffhand(player).stream().filter(s -> s.func_77973_b() instanceof ItemArtefact && ((ItemArtefact)s.func_77973_b()).type == ((ItemArtefact)artefact).type).limit(((ItemArtefact)artefact).type.maxAtOnce).anyMatch(s -> s.func_77973_b() == artefact);
    }

    public static List<ItemArtefact> getActiveArtefacts(EntityPlayer player, Type ... types) {
        if (types.length == 0) {
            types = Type.values();
        }
        if (WizardryBaublesIntegration.enabled()) {
            List<ItemArtefact> artefacts = WizardryBaublesIntegration.getEquippedArtefacts(player, types);
            artefacts.removeIf(i -> !i.enabled);
            return artefacts;
        }
        ArrayList<ItemArtefact> artefacts = new ArrayList<ItemArtefact>();
        for (Type type : types) {
            artefacts.addAll(InventoryUtils.getPrioritisedHotbarAndOffhand(player).stream().filter(s -> s.func_77973_b() instanceof ItemArtefact).map(s -> (ItemArtefact)s.func_77973_b()).filter(i -> type == i.type && i.enabled).limit(type.maxAtOnce).collect(Collectors.toList()));
        }
        return artefacts;
    }

    public static boolean findMatchingWandAndExecute(EntityPlayer player, Spell spell, Consumer<? super ItemStack> action) {
        List<ItemStack> hotbar = InventoryUtils.getPrioritisedHotbarAndOffhand(player);
        Optional<ItemStack> stack = hotbar.stream().filter(s -> s.func_77973_b() instanceof ISpellCastingItem && Arrays.asList(((ISpellCastingItem)s.func_77973_b()).getSpells((ItemStack)s)).contains(spell)).findFirst();
        stack.ifPresent(action);
        return stack.isPresent();
    }

    public static boolean findMatchingWandAndCast(EntityPlayer player, Spell spell) {
        return ItemArtefact.findMatchingWandAndExecute(player, spell, wand -> {
            SpellModifiers modifiers = new SpellModifiers();
            if (((ISpellCastingItem)wand.func_77973_b()).canCast((ItemStack)wand, spell, player, EnumHand.MAIN_HAND, 0, modifiers)) {
                ((ISpellCastingItem)wand.func_77973_b()).cast((ItemStack)wand, spell, player, EnumHand.MAIN_HAND, 0, modifiers);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            World world = player.field_70170_p;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts(player, new Type[0])) {
                if (artefact == WizardryItems.ring_condensing) {
                    if (player.field_70173_aa % 150 != 0) continue;
                    for (ItemStack stack : InventoryUtils.getHotbar(player)) {
                        if (!(stack.func_77973_b() instanceof ISpellCastingItem) || !(stack.func_77973_b() instanceof IManaStoringItem)) continue;
                        ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 1);
                    }
                    continue;
                }
                if (artefact == WizardryItems.amulet_arcane_defence) {
                    if (player.field_70173_aa % 300 != 0) continue;
                    for (ItemStack stack : player.func_184193_aE()) {
                        if (!(stack.func_77973_b() instanceof IManaStoringItem)) continue;
                        ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 1);
                    }
                    continue;
                }
                if (artefact == WizardryItems.amulet_recovery) {
                    int totalArmourMana;
                    if (!player.func_70996_bM() || !(player.func_110143_aJ() < player.func_110138_aP() / 2.0f) || player.field_70173_aa % 50 != 0 || (totalArmourMana = Streams.stream((Iterable)player.func_184193_aE()).filter(s -> s.func_77973_b() instanceof IManaStoringItem).mapToInt(s -> ((IManaStoringItem)s.func_77973_b()).getMana((ItemStack)s)).sum()) < 2) continue;
                    player.func_70691_i(1.0f);
                    List chargedArmour = Streams.stream((Iterable)player.func_184193_aE()).filter(s -> s.func_77973_b() instanceof IManaStoringItem).filter(s -> !((IManaStoringItem)s.func_77973_b()).isManaEmpty((ItemStack)s)).collect(Collectors.toList());
                    if (chargedArmour.size() == 1) {
                        ((IManaStoringItem)((ItemStack)chargedArmour.get(0)).func_77973_b()).consumeMana((ItemStack)chargedArmour.get(0), 2, (EntityLivingBase)player);
                        continue;
                    }
                    Collections.shuffle(chargedArmour);
                    ((IManaStoringItem)((ItemStack)chargedArmour.get(0)).func_77973_b()).consumeMana((ItemStack)chargedArmour.get(0), 1, (EntityLivingBase)player);
                    ((IManaStoringItem)((ItemStack)chargedArmour.get(1)).func_77973_b()).consumeMana((ItemStack)chargedArmour.get(1), 1, (EntityLivingBase)player);
                    continue;
                }
                if (artefact == WizardryItems.amulet_glide) {
                    WizardData data;
                    if (player.field_70143_R > 3.0f && player.field_70143_R < 3.5f && player.field_70170_p.field_73012_v.nextFloat() < 0.5f) {
                        if (WizardData.get(player).isCasting()) continue;
                        WizardData.get(player).startCastingContinuousSpell(Spells.glide, new SpellModifiers(), 600);
                        continue;
                    }
                    if (!player.field_70122_E || (data = WizardData.get(player)).currentlyCasting() != Spells.glide) continue;
                    data.stopCastingContinuousSpell();
                    continue;
                }
                if (artefact == WizardryItems.amulet_auto_shield) {
                    ItemArtefact.findMatchingWandAndExecute(player, Spells.shield, wand -> {
                        if (wand.func_77973_b() instanceof ItemScroll) {
                            return;
                        }
                        List<Entity> projectiles = EntityUtils.getEntitiesWithinRadius(5.0, player.field_70165_t, player.field_70163_u, player.field_70161_v, world, Entity.class);
                        projectiles.removeIf(e -> !(e instanceof IProjectile));
                        Vec3d look = player.func_70040_Z();
                        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)(player.field_70131_O / 2.0f), 0.0);
                        for (Entity projectile : projectiles) {
                            Vec3d velocity;
                            double angle1;
                            Vec3d vec = playerPos.func_178788_d(projectile.func_174791_d()).func_72432_b();
                            double angle = Math.acos(vec.func_186678_a(-1.0).func_72430_b(look));
                            if (angle > 1.2566370801612687 || !((angle1 = Math.acos(vec.func_72430_b(velocity = new Vec3d(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y).func_72432_b()))) < 0.6283185400806344)) continue;
                            SpellModifiers modifiers = new SpellModifiers();
                            if (!((ISpellCastingItem)wand.func_77973_b()).canCast((ItemStack)wand, Spells.shield, player, EnumHand.MAIN_HAND, 0, modifiers)) break;
                            ((ISpellCastingItem)wand.func_77973_b()).cast((ItemStack)wand, Spells.shield, player, EnumHand.MAIN_HAND, 0, modifiers);
                            break;
                        }
                    });
                    continue;
                }
                if (artefact == WizardryItems.amulet_frost_warding) {
                    List barriers;
                    if (world.field_72995_K || player.field_70173_aa % 40 != 0 || (barriers = world.func_72872_a(EntityIceBarrier.class, player.func_174813_aQ().func_186662_g(1.5))).isEmpty() || !barriers.stream().anyMatch(b -> b.func_70040_Z().func_72430_b(b.func_174791_d().func_178788_d(player.func_174791_d())) > 0.0)) continue;
                    player.func_70690_d(new PotionEffect(WizardryPotions.ward, 50, 1));
                    continue;
                }
                if (artefact != WizardryItems.charm_feeding || player.field_70173_aa % 100 != 0 || player.func_71024_bL().func_75116_a() < 20 - Spells.satiety.getProperty("hunger_points").intValue() && ItemArtefact.findMatchingWandAndCast(player, Spells.satiety) || player.func_71024_bL().func_75116_a() >= 20 - Spells.replenish_hunger.getProperty("hunger_points").intValue()) continue;
                ItemArtefact.findMatchingWandAndCast(player, Spells.replenish_hunger);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts(player, new Type[0])) {
                float potency = modifiers.get("potency");
                float cooldown = modifiers.get(WizardryItems.cooldown_upgrade);
                Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
                if (artefact == WizardryItems.ring_battlemage) {
                    if (!(player.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) || !ImbueWeapon.isSword(player.func_184614_ca())) continue;
                    modifiers.set("potency", 1.1f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_fire_biome) {
                    if (event.getSpell().getElement() != Element.FIRE || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) continue;
                    modifiers.set("potency", 1.3f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_ice_biome) {
                    if (event.getSpell().getElement() != Element.ICE || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) continue;
                    modifiers.set("potency", 1.3f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_earth_biome) {
                    if (event.getSpell().getElement() != Element.EARTH || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
                    modifiers.set("potency", 1.3f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_storm) {
                    if (event.getSpell().getElement() != Element.LIGHTNING || !player.field_70170_p.func_72911_I()) continue;
                    modifiers.set(WizardryItems.cooldown_upgrade, cooldown * 0.3f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_full_moon) {
                    if (event.getSpell().getElement() != Element.EARTH || player.field_70170_p.func_72935_r() || player.field_70170_p.field_73011_w.func_76559_b(player.field_70170_p.func_72820_D()) != 0) continue;
                    modifiers.set(WizardryItems.cooldown_upgrade, cooldown * 0.3f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_blockwrangler) {
                    if (event.getSpell() != Spells.greater_telekinesis) continue;
                    modifiers.set("potency", modifiers.get("potency") * 2.0f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_conjurer) {
                    if (!(event.getSpell() instanceof SpellConjuration)) continue;
                    modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 2.0f, false);
                    continue;
                }
                if (artefact == WizardryItems.charm_minion_health) {
                    modifiers.set("minion_health", 1.25f * modifiers.get("minion_health"), true);
                    continue;
                }
                if (artefact == WizardryItems.charm_flight) {
                    if (event.getSpell() != Spells.flight && event.getSpell() != Spells.glide) continue;
                    modifiers.set("potency", 1.5f * potency, true);
                    continue;
                }
                if (artefact == WizardryItems.charm_experience_tome) {
                    modifiers.set("progression", modifiers.get("progression") * 1.5f, false);
                    continue;
                }
                if (artefact != WizardryItems.charm_hunger_casting || player.field_71075_bZ.field_75098_d || event.getSource() != SpellCastEvent.Source.WAND || event.getSpell().isContinuous) continue;
                ItemStack wand = player.func_184614_ca();
                if (!(wand.func_77973_b() instanceof ISpellCastingItem && wand.func_77973_b() instanceof IManaStoringItem || (wand = player.func_184592_cb()).func_77973_b() instanceof ISpellCastingItem && wand.func_77973_b() instanceof IManaStoringItem)) {
                    return;
                }
                if (!((float)((IManaStoringItem)wand.func_77973_b()).getMana(wand) < (float)event.getSpell().getCost() * modifiers.get("cost"))) continue;
                int hunger = event.getSpell().getCost() / 5;
                if (player.func_71024_bL().func_75116_a() < hunger) continue;
                player.func_71024_bL().func_75122_a(-hunger, 0.0f);
                modifiers.set("cost", 0.0f, false);
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        EntityPlayer player;
        if (event.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive(player = (EntityPlayer)event.getCaster(), WizardryItems.ring_paladin) && (event.getSpell() instanceof Heal || event.getSpell() instanceof HealAlly || event.getSpell() instanceof GreaterHeal)) {
            float healthGained = event.getSpell().getProperty("health").floatValue() * event.getModifiers().get("potency");
            List<EntityLivingBase> nearby = EntityUtils.getLivingWithinRadius(4.0, player.field_70165_t, player.field_70163_u, player.field_70161_v, event.getWorld());
            for (EntityLivingBase entity : nearby) {
                if (!AllyDesignationSystem.isAllied((EntityLivingBase)player, entity) || !(entity.func_110143_aJ() > 0.0f) || !(entity.func_110143_aJ() < entity.func_110138_aP())) continue;
                entity.func_70691_i(healthGained * 0.2f);
                if (!event.getWorld().field_72995_K) continue;
                ParticleBuilder.spawnHealParticles(event.getWorld(), entity);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Entity caster;
        NBTTagCompound entityNBT;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70173_aa % 50 == 0 && entity.func_70644_a(WizardryPotions.mind_control) && (entityNBT = entity.getEntityData()).func_186855_b("controllingEntity") && (caster = EntityUtils.getEntityByUUID(entity.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)caster, WizardryItems.ring_mind_control)) {
            EntityUtils.getEntitiesWithinRadius(3.0, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70170_p, EntityLiving.class).stream().filter(e -> e.field_70170_p.field_73012_v.nextInt(10) == 0).filter(MindControl::canControl).filter(e -> AllyDesignationSystem.isValidTarget(caster, (Entity)e)).forEach(target -> MindControl.startControlling(target, (EntityLivingBase)((EntityPlayer)caster), entity.func_70660_b(WizardryPotions.mind_control).func_76459_b()));
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts(player, new Type[0])) {
                EntityLivingBase target2;
                if (artefact == WizardryItems.amulet_warding) {
                    if (event.getSource().func_76363_c() || !event.getSource().func_82725_o()) continue;
                    event.setAmount(event.getAmount() * 0.9f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_fire_protection) {
                    if (!event.getSource().func_76347_k()) continue;
                    event.setAmount(event.getAmount() * 0.7f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_ice_protection) {
                    if (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FROST) continue;
                    event.setAmount(event.getAmount() * 0.7f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_channeling) {
                    if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.3f) || !(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.SHOCK) continue;
                    event.setCanceled(true);
                    return;
                }
                if (artefact == WizardryItems.amulet_fire_cloaking) {
                    if (event.getSource().func_76363_c()) continue;
                    List fireRings = player.field_70170_p.func_72872_a(EntityFireRing.class, player.func_174813_aQ());
                    for (EntityFireRing fireRing : fireRings) {
                        if (!(fireRing.getCaster() instanceof EntityPlayer) || fireRing.getCaster() != player && !AllyDesignationSystem.isOwnerAlly(player, fireRing)) continue;
                        event.setAmount(event.getAmount() * 0.25f);
                    }
                    continue;
                }
                if (artefact == WizardryItems.amulet_potential) {
                    if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !EntityUtils.isMeleeDamage(event.getSource()) || !(event.getSource().func_76346_g() instanceof EntityLivingBase)) continue;
                    target2 = (EntityLivingBase)event.getSource().func_76346_g();
                    if (player.field_70170_p.field_72995_K) {
                        ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity(event.getEntity()).pos(0.0, event.getEntity().field_70131_O / 2.0f, 0.0).target((Entity)target2).spawn(player.field_70170_p);
                        ParticleBuilder.spawnShockParticles(player.field_70170_p, target2.field_70165_t, target2.field_70163_u + (double)(target2.field_70131_O / 2.0f), target2.field_70161_v);
                    }
                    DamageSafetyChecker.attackEntitySafely((Entity)target2, MagicDamage.causeDirectMagicDamage((Entity)player, MagicDamage.DamageType.SHOCK, true), Spells.static_aura.getProperty("damage").floatValue(), event.getSource().func_76355_l());
                    target2.func_184185_a(WizardrySounds.SPELL_STATIC_AURA_RETALIATE, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_lich) {
                    if (event.getSource().func_76363_c() || !(player.field_70170_p.field_73012_v.nextFloat() < 0.15f)) continue;
                    List<EntityLiving> nearbyMobs = EntityUtils.getEntitiesWithinRadius(5.0, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p, EntityLiving.class);
                    nearbyMobs.removeIf(e -> !(e instanceof ISummonedCreature) || ((ISummonedCreature)e).getCaster() != player);
                    if (nearbyMobs.isEmpty()) continue;
                    Collections.shuffle(nearbyMobs);
                    DamageSafetyChecker.attackEntitySafely((Entity)nearbyMobs.get(0), event.getSource(), event.getAmount(), event.getSource().func_76355_l());
                    event.setCanceled(true);
                    return;
                }
                if (artefact == WizardryItems.amulet_banishing) {
                    if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !EntityUtils.isMeleeDamage(event.getSource()) || !(event.getSource().func_76346_g() instanceof EntityLivingBase)) continue;
                    target2 = (EntityLivingBase)event.getSource().func_76346_g();
                    ((Banish)Spells.banish).teleport(target2, target2.field_70170_p, 8.0 + target2.field_70170_p.field_73012_v.nextDouble() * 8.0);
                    continue;
                }
                if (artefact != WizardryItems.amulet_transience || !(player.func_110143_aJ() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                player.func_70690_d(new PotionEffect(WizardryPotions.transience, 300));
                player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 300, 0, false, false));
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack mainhandItem = player.func_184614_ca();
            World world = player.field_70170_p;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts(player, new Type[0])) {
                if (artefact == WizardryItems.ring_fire_melee) {
                    if (!EntityUtils.isMeleeDamage(event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.FIRE) continue;
                    event.getEntity().func_70015_d(5);
                    continue;
                }
                if (artefact == WizardryItems.ring_ice_melee) {
                    if (!EntityUtils.isMeleeDamage(event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.ICE) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.frost, 200, 0));
                    continue;
                }
                if (artefact == WizardryItems.ring_lightning_melee) {
                    if (!EntityUtils.isMeleeDamage(event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.LIGHTNING) continue;
                    EntityUtils.getLivingWithinRadius(3.0, player.field_70165_t, player.field_70163_u, player.field_70161_v, world).stream().filter(EntityUtils::isLiving).filter(e -> e != player).min(Comparator.comparingDouble(arg_0 -> ((EntityPlayer)player).func_70068_e(arg_0))).ifPresent(target -> {
                        if (world.field_72995_K) {
                            ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).entity(event.getEntity()).pos(0.0, event.getEntity().field_70131_O / 2.0f, 0.0).target((Entity)target).spawn(world);
                            ParticleBuilder.spawnShockParticles(world, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                        }
                        DamageSafetyChecker.attackEntitySafely((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)player, MagicDamage.DamageType.SHOCK, true), Spells.static_aura.getProperty("damage").floatValue(), event.getSource().func_76355_l());
                        target.func_184185_a(WizardrySounds.SPELL_STATIC_AURA_RETALIATE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    });
                    continue;
                }
                if (artefact == WizardryItems.ring_necromancy_melee) {
                    if (!EntityUtils.isMeleeDamage(event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.NECROMANCY) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 0));
                    continue;
                }
                if (artefact == WizardryItems.ring_earth_melee) {
                    if (!EntityUtils.isMeleeDamage(event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.EARTH) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                    continue;
                }
                if (artefact == WizardryItems.ring_shattering) {
                    if (player.field_70170_p.field_72995_K || !(player.field_70170_p.field_73012_v.nextFloat() < 0.15f) || !(event.getEntityLiving().func_110143_aJ() < 12.0f) || !event.getEntityLiving().func_70644_a(WizardryPotions.frost) || !EntityUtils.isMeleeDamage(event.getSource())) continue;
                    event.setAmount(12.0f);
                    for (int i = 0; i < 8; ++i) {
                        double dx = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                        double dy = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                        double dz = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                        EntityIceShard iceshard = new EntityIceShard(event.getEntity().field_70170_p);
                        iceshard.func_70107_b(event.getEntity().field_70165_t + dx + Math.signum(dx) * (double)event.getEntity().field_70130_N, event.getEntity().field_70163_u + (double)(event.getEntity().field_70131_O / 2.0f) + dy, event.getEntity().field_70161_v + dz + Math.signum(dz) * (double)event.getEntity().field_70130_N);
                        iceshard.field_70159_w = dx * 1.5;
                        iceshard.field_70181_x = dy * 1.5;
                        iceshard.field_70179_y = dz * 1.5;
                        iceshard.setCaster((EntityLivingBase)player);
                        event.getEntity().field_70170_p.func_72838_d((Entity)iceshard);
                    }
                    continue;
                }
                if (artefact == WizardryItems.ring_soulbinding) {
                    if ((!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.WITHER) && (event.getSource().func_76364_f() != player || EntityUtils.isMeleeDamage(event.getSource()) || !Streams.stream((Iterable)player.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell((ItemStack)s).getElement() == Element.NECROMANCY))) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.curse_of_soulbinding, 400));
                    CurseOfSoulbinding.getSoulboundCreatures(WizardData.get(player)).add(event.getEntity().func_110124_au());
                    continue;
                }
                if (artefact == WizardryItems.ring_leeching) {
                    if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.3f) || (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.WITHER) && (event.getSource().func_76364_f() != player || EntityUtils.isMeleeDamage(event.getSource()) || !Streams.stream((Iterable)player.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell((ItemStack)s).getElement() == Element.NECROMANCY && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell((ItemStack)s) != Spells.life_drain)) || !player.func_70996_bM()) continue;
                    player.func_70691_i(event.getAmount() * Spells.life_drain.getProperty("heal_factor").floatValue());
                    continue;
                }
                if (artefact == WizardryItems.ring_poison) {
                    if ((!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.POISON) && !(event.getSource().func_76364_f() instanceof EntityDart) && (event.getSource().func_76364_f() != player || EntityUtils.isMeleeDamage(event.getSource()) || !Streams.stream((Iterable)player.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell((ItemStack)s).getElement() == Element.EARTH))) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                    continue;
                }
                if (artefact != WizardryItems.ring_extraction || (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FORCE) && !(event.getSource().func_76364_f() instanceof EntityForceOrb) && (event.getSource().func_76364_f() != player || EntityUtils.isMeleeDamage(event.getSource()) || !Streams.stream((Iterable)player.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell((ItemStack)s).getElement() == Element.SORCERY))) continue;
                InventoryUtils.getPrioritisedHotbarAndOffhand(player).stream().filter(s -> s.func_77973_b() instanceof ISpellCastingItem && s.func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)s.func_77973_b()).isManaFull((ItemStack)s)).findFirst().ifPresent(s -> ((IManaStoringItem)s.func_77973_b()).rechargeMana((ItemStack)s, 4 + world.field_73012_v.nextInt(3)));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts(player, new Type[0])) {
                if (artefact == WizardryItems.ring_combustion) {
                    if (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FIRE) continue;
                    event.getEntity().field_70170_p.func_72876_a(event.getEntity(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, 1.5f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_disintegration) {
                    if (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FIRE) continue;
                    Disintegration.spawnEmbers(event.getEntity().field_70170_p, (EntityLivingBase)player, event.getEntity(), Spells.disintegration.getProperty("ember_count").intValue());
                    continue;
                }
                if (artefact != WizardryItems.ring_arcane_frost || player.field_70170_p.field_72995_K || !(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FROST) continue;
                for (int i = 0; i < 8; ++i) {
                    double dx = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                    double dy = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                    double dz = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                    EntityIceShard iceshard = new EntityIceShard(event.getEntity().field_70170_p);
                    iceshard.func_70107_b(event.getEntity().field_70165_t + dx + Math.signum(dx) * (double)event.getEntity().field_70130_N, event.getEntity().field_70163_u + (double)(event.getEntity().field_70131_O / 2.0f) + dy, event.getEntity().field_70161_v + dz + Math.signum(dz) * (double)event.getEntity().field_70130_N);
                    iceshard.field_70159_w = dx * 1.5;
                    iceshard.field_70181_x = dy * 1.5;
                    iceshard.field_70179_y = dz * 1.5;
                    iceshard.setCaster((EntityLivingBase)player);
                    event.getEntity().field_70170_p.func_72838_d((Entity)iceshard);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDropsEvent(PlayerDropsEvent event) {
        if (ItemArtefact.isArtefactActive(event.getEntityPlayer(), WizardryItems.amulet_resurrection)) {
            EntityItem item = event.getDrops().stream().filter(e -> Resurrection.canStackResurrect(e.func_92059_d(), event.getEntityPlayer())).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            if (!InventoryUtils.getHotbar(event.getEntityPlayer()).contains(ItemStack.field_190927_a)) {
                return;
            }
            event.getDrops().remove(item);
            if (event.getEntityPlayer().func_184614_ca().func_190926_b()) {
                event.getEntityPlayer().func_184611_a(EnumHand.MAIN_HAND, item.func_92059_d());
            } else {
                event.getEntityPlayer().func_191521_c(item.func_92059_d());
            }
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts(player, new Type[0])) {
                if (artefact == WizardryItems.amulet_ice_immunity) {
                    if (event.getPotionEffect().func_188419_a() != WizardryPotions.frost) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact != WizardryItems.amulet_wither_immunity || event.getPotionEffect().func_188419_a() != MobEffects.field_82731_v) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickupEvent(PlayerEvent.ItemPickupEvent event) {
        if (ItemArtefact.isArtefactActive(event.player, WizardryItems.charm_auto_smelt) && event.player.field_71071_by.field_70462_a.stream().filter(s -> !FurnaceRecipes.func_77602_a().func_151395_a(s).func_190926_b()).mapToInt(ItemStack::func_190916_E).sum() >= Spells.pocket_furnace.getProperty("items_smelted").intValue()) {
            ItemArtefact.findMatchingWandAndCast(event.player, Spells.pocket_furnace);
        }
    }

    public static enum Type {
        RING(2),
        AMULET(1),
        CHARM(1);

        public final int maxAtOnce;

        private Type(int maxAtOnce) {
            this.maxAtOnce = maxAtOnce;
        }
    }
}

