/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.inventory;

import electroblob.wizardry.Settings;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockBookshelf;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerBookshelf
extends Container {
    private static final Set<Item> validItems = new HashSet<Item>();
    public TileEntityBookshelf tileentity;

    public ContainerBookshelf(IInventory inventory, TileEntityBookshelf tileentity) {
        int x;
        int y;
        this.tileentity = tileentity;
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < 6; ++x) {
                this.func_75146_a(new SlotBookshelf((IInventory)tileentity, x + 6 * y, 35 + x * 18, 17 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot(inventory, x2, 8 + x2 * 18, 124));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(inventory, 9 + x + y * 9, 8 + x * 18, 66 + y * 18));
            }
        }
    }

    public void onSlotChanged() {
        this.tileentity.sync();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileentity.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlotId) {
        ItemStack remainder = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            remainder = stack.func_77946_l();
            if (clickedSlotId < 12) {
                if (!this.func_75135_a(stack, 12, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                int minSlotId = 0;
                int maxSlotId = 11;
                if (!ContainerBookshelf.isBook(stack)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack, minSlotId, maxSlotId + 1, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == remainder.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return remainder;
    }

    public static boolean isBook(ItemStack stack) {
        return validItems.contains(stack.func_77973_b()) || Settings.containsMetaItem(Wizardry.settings.bookItems, stack);
    }

    public static void registerBookItem(Item item) {
        validItems.add(item);
    }

    public static void initDefaultBookItems() {
        ContainerBookshelf.registerBookItem(Items.field_151122_aG);
        ContainerBookshelf.registerBookItem(Items.field_151164_bB);
        ContainerBookshelf.registerBookItem(Items.field_151099_bA);
        ContainerBookshelf.registerBookItem(Items.field_151134_bR);
        ContainerBookshelf.registerBookItem(WizardryItems.spell_book);
        ContainerBookshelf.registerBookItem(WizardryItems.arcane_tome);
        ContainerBookshelf.registerBookItem(WizardryItems.wizard_handbook);
        ContainerBookshelf.registerBookItem(WizardryItems.ruined_spell_book);
        ContainerBookshelf.registerBookItem(WizardryItems.scroll);
        ContainerBookshelf.registerBookItem(WizardryItems.blank_scroll);
        ContainerBookshelf.registerBookItem(WizardryItems.identification_scroll);
        ContainerBookshelf.registerBookItem(WizardryItems.storage_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.siphon_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.condenser_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.range_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.duration_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.cooldown_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.blast_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.attunement_upgrade);
        ContainerBookshelf.registerBookItem(WizardryItems.melee_upgrade);
    }

    public class SlotBookshelf
    extends Slot {
        public SlotBookshelf(IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public void func_75215_d(ItemStack stack) {
            boolean statusChanged = this.func_75211_c().func_190926_b() != stack.func_190926_b() || BlockBookshelf.getBookItems().indexOf((Object)this.func_75211_c().func_77973_b()) != BlockBookshelf.getBookItems().indexOf((Object)stack.func_77973_b());
            super.func_75215_d(stack);
            if (statusChanged) {
                ContainerBookshelf.this.onSlotChanged();
            }
        }

        public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
            ItemStack result = super.func_190901_a(player, stack);
            ContainerBookshelf.this.onSlotChanged();
            return result;
        }

        public boolean func_75214_a(ItemStack stack) {
            return ContainerBookshelf.isBook(stack);
        }
    }
}

