/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.entity.projectile.EntityBomb;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySparkBomb
extends EntityBomb {
    public static final String SECONDARY_MAX_TARGETS = "secondary_max_targets";

    public EntitySparkBomb(World world) {
        super(world);
    }

    @Override
    public int getLifetime() {
        return -1;
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        this.func_184185_a(WizardrySounds.ENTITY_SPARK_BOMB_HIT_BLOCK, 0.5f, 0.5f);
        Entity entityHit = rayTrace.field_72308_g;
        if (entityHit != null) {
            float damage = Spells.spark_bomb.getProperty("direct_damage").floatValue() * this.damageMultiplier;
            this.func_184185_a(WizardrySounds.ENTITY_SPARK_BOMB_HIT, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            entityHit.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), MagicDamage.DamageType.SHOCK).func_76349_b(), damage);
        }
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.spawnShockParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
        }
        double seekerRange = Spells.spark_bomb.getProperty("effect_radius").doubleValue() * (double)this.blastMultiplier;
        List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(seekerRange, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
        for (int i = 0; i < Math.min(targets.size(), Spells.spark_bomb.getProperty(SECONDARY_MAX_TARGETS).intValue()); ++i) {
            boolean flag;
            boolean bl = flag = targets.get(i) != entityHit && targets.get(i) != this.func_85052_h() && (!(targets.get(i) instanceof EntityPlayer) || !((EntityPlayer)targets.get(i)).func_184812_l_());
            if (!flag) continue;
            EntityLivingBase target = targets.get(i);
            if (!this.field_70170_p.field_72995_K) {
                target.func_184185_a(WizardrySounds.ENTITY_SPARK_BOMB_CHAIN, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 1.5f);
                target.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), MagicDamage.DamageType.SHOCK), Spells.spark_bomb.getProperty("splash_damage").floatValue() * this.damageMultiplier);
                continue;
            }
            ParticleBuilder.create(ParticleBuilder.Type.LIGHTNING).pos(this.func_174791_d()).target((Entity)target).spawn(this.field_70170_p);
            ParticleBuilder.spawnShockParticles(this.field_70170_p, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
        }
        this.func_70106_y();
    }
}

