/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityForceArrow
extends EntityMagicArrow {
    private int mana = 0;

    public EntityForceArrow(World world) {
        super(world);
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Override
    public void onEntityHit(EntityLivingBase entityHit) {
        this.func_184185_a(WizardrySounds.ENTITY_FORCE_ARROW_HIT, 1.0f, 1.0f);
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(this.field_70165_t, this.field_70163_u, this.field_70161_v).scale(1.3f).clr(0.75f, 1.0f, 0.85f).spawn(this.field_70170_p);
        }
    }

    @Override
    public void tickInGround() {
        this.returnManaToCaster();
        this.func_70106_y();
    }

    @Override
    public void func_70071_h_() {
        if (this.getLifetime() >= 0 && this.field_70173_aa > this.getLifetime()) {
            this.returnManaToCaster();
        }
        super.func_70071_h_();
    }

    private void returnManaToCaster() {
        if (this.mana > 0 && this.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.getCaster();
            if (!player.field_71075_bZ.field_75098_d && ItemArtefact.isArtefactActive(player, WizardryItems.ring_mana_return)) {
                for (ItemStack stack : InventoryUtils.getPrioritisedHotbarAndOffhand(player)) {
                    if (!(stack.func_77973_b() instanceof ISpellCastingItem) || !(stack.func_77973_b() instanceof IManaStoringItem) || !Arrays.asList(((ISpellCastingItem)stack.func_77973_b()).getSpells(stack)).contains(Spells.force_arrow)) continue;
                    ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, this.mana);
                }
            }
        }
    }

    @Override
    public void onBlockHit(RayTraceResult hit) {
        this.func_184185_a(WizardrySounds.ENTITY_FORCE_ARROW_HIT, 1.0f, 1.0f);
        if (this.field_70170_p.field_72995_K) {
            Vec3d vec = hit.field_72307_f.func_178787_e(new Vec3d(hit.field_178784_b.func_176730_m()).func_186678_a(0.15));
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(vec).scale(1.3f).clr(0.75f, 1.0f, 0.85f).spawn(this.field_70170_p);
        }
    }

    @Override
    public int getLifetime() {
        return 20;
    }

    @Override
    public double getDamage() {
        return Spells.force_arrow.getProperty("damage").floatValue();
    }

    @Override
    public MagicDamage.DamageType getDamageType() {
        return MagicDamage.DamageType.FORCE;
    }

    @Override
    public boolean doGravity() {
        return false;
    }

    @Override
    public boolean doDeceleration() {
        return false;
    }

    @Override
    protected void func_70088_a() {
    }
}

