/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.construct;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.construct.EntityScaledConstruct;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWitheringTotem
extends EntityScaledConstruct {
    private static final int PERIMETER_PARTICLE_DENSITY = 6;
    private static final DataParameter<Float> HEALTH_DRAINED = EntityDataManager.func_187226_a(EntityWitheringTotem.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityWitheringTotem(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HEALTH_DRAINED, (Object)Float.valueOf(0.0f));
    }

    public float getHealthDrained() {
        return ((Float)this.field_70180_af.func_187225_a(HEALTH_DRAINED)).floatValue();
    }

    public void addHealthDrained(float health) {
        this.field_70180_af.func_187227_b(HEALTH_DRAINED, (Object)Float.valueOf(this.getHealthDrained() + health));
    }

    @Override
    protected boolean shouldScaleWidth() {
        return false;
    }

    @Override
    protected boolean shouldScaleHeight() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            Wizardry.proxy.playMovingSound(this, WizardrySounds.ENTITY_WITHERING_TOTEM_AMBIENT, WizardrySounds.SPELLS, 1.0f, 1.0f, true);
        }
        super.func_70071_h_();
        double radius = Spells.withering_totem.getProperty("effect_radius").floatValue() * this.sizeMultiplier;
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.DUST, this.field_70146_Z, this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, 0.3, false).vel(0.0, -0.02 - (double)this.field_70170_p.field_73012_v.nextFloat() * 0.01, 0.0).clr(0xF575F5).fade(3679078).spawn(this.field_70170_p);
            for (int i = 0; i < 6; ++i) {
                double z;
                float angle = 1.0471976f * ((float)i + this.field_70146_Z.nextFloat());
                double x = this.field_70165_t + radius * (double)MathHelper.func_76126_a((float)angle);
                Integer y = BlockUtils.getNearestSurface(this.field_70170_p, new BlockPos(x, this.field_70163_u, z = this.field_70161_v + radius * (double)MathHelper.func_76134_b((float)angle)), EnumFacing.UP, 5, true, BlockUtils.SurfaceCriteria.COLLIDABLE);
                if (y == null) continue;
                ParticleBuilder.create(ParticleBuilder.Type.DUST).pos(x, y.intValue(), z).vel(0.0, 0.01, 0.0).clr(0xF575F5).fade(3679078).spawn(this.field_70170_p);
            }
        }
        List<EntityLivingBase> nearby = EntityUtils.getLivingWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
        nearby.removeIf(e -> !this.isValidTarget((Entity)e));
        nearby.sort(Comparator.comparingDouble(e -> e.func_70068_e((Entity)this)));
        int targetsRemaining = Spells.withering_totem.getProperty("max_targets").intValue() + (int)((this.damageMultiplier - 1.0f) / 0.15f);
        while (!nearby.isEmpty() && targetsRemaining > 0) {
            EntityLivingBase target = nearby.remove(0);
            if (!EntityUtils.isLiving((Entity)target)) continue;
            if (target.field_70173_aa % target.field_70771_an == 1) {
                float damage = Spells.withering_totem.getProperty("damage").floatValue();
                if (EntityUtils.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.WITHER), damage)) {
                    this.addHealthDrained(damage);
                }
            }
            --targetsRemaining;
            if (!this.field_70170_p.field_72995_K) continue;
            Vec3d centre = GeometryUtils.getCentre(this);
            Vec3d pos = GeometryUtils.getCentre((Entity)target);
            ParticleBuilder.create(ParticleBuilder.Type.BEAM).pos(centre).target((Entity)target).clr(0.1f + 0.2f * this.field_70170_p.field_73012_v.nextFloat(), 0.0f, 0.3f).spawn(this.field_70170_p);
            for (int i = 0; i < 3; ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.DUST, this.field_70146_Z, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.3, false).vel(pos.func_178788_d(centre).func_72432_b().func_186678_a(-0.1)).clr(786468).fade(6357015).spawn(this.field_70170_p);
            }
        }
    }

    @Override
    public void despawn() {
        double radius = Spells.withering_totem.getProperty("effect_radius").floatValue() * this.sizeMultiplier;
        List<EntityLivingBase> nearby = EntityUtils.getLivingWithinRadius(radius, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
        nearby.removeIf(e -> !this.isValidTarget((Entity)e));
        float damage = Math.min(this.getHealthDrained() * 0.2f, Spells.withering_totem.getProperty("max_explosion_damage").floatValue());
        for (EntityLivingBase target : nearby) {
            if (!EntityUtils.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeIndirectMagicDamage(this, (Entity)this.getCaster(), MagicDamage.DamageType.MAGIC), damage)) continue;
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, Spells.withering_totem.getProperty("effect_duration").intValue(), Spells.withering_totem.getProperty("effect_strength").intValue()));
        }
        if (this.field_70170_p.field_72995_K) {
            ParticleBuilder.create(ParticleBuilder.Type.SPHERE).pos(GeometryUtils.getCentre(this)).scale((float)radius).clr(12458579).fade(2166602).spawn(this.field_70170_p);
        }
        this.func_184185_a(WizardrySounds.ENTITY_WITHERING_TOTEM_EXPLODE, 1.0f, 1.0f);
        super.despawn();
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeFloat(this.damageMultiplier);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.damageMultiplier = data.readFloat();
    }
}

