/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.data;

import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.util.NBTExtras;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public interface IStoredVariable<T>
extends IVariable<T> {
    public void write(NBTTagCompound var1, T var2);

    public T read(NBTTagCompound var1);

    public static class StoredVariable<T, E extends NBTBase>
    implements IStoredVariable<T> {
        private final String key;
        private final Persistence persistence;
        private final Function<T, E> serialiser;
        private final Function<E, T> deserialiser;
        private boolean synced;
        private BiFunction<EntityPlayer, T, T> ticker;

        public StoredVariable(String key, Function<T, E> serialiser, Function<E, T> deserialiser, Persistence persistence) {
            this.key = key;
            this.serialiser = serialiser;
            this.deserialiser = deserialiser;
            this.persistence = persistence;
            this.ticker = (p, t) -> t;
        }

        public StoredVariable<T, E> withTicker(BiFunction<EntityPlayer, T, T> ticker) {
            this.ticker = ticker;
            return this;
        }

        public StoredVariable<T, E> setSynced() {
            this.synced = true;
            return this;
        }

        @Override
        public void write(NBTTagCompound nbt, T value) {
            if (value != null) {
                NBTExtras.storeTagSafely(nbt, this.key, (NBTBase)this.serialiser.apply(value));
            }
        }

        @Override
        public T read(NBTTagCompound nbt) {
            return nbt.func_74764_b(this.key) ? (T)this.deserialiser.apply(nbt.func_74781_a(this.key)) : null;
        }

        @Override
        public T update(EntityPlayer player, T value) {
            return this.ticker.apply(player, (EntityPlayer)value);
        }

        @Override
        public boolean isPersistent(boolean respawn) {
            return respawn ? this.persistence.persistsOnRespawn() : this.persistence.persistsOnDimensionChange();
        }

        @Override
        public boolean isSynced() {
            return this.synced;
        }

        @Override
        public void write(ByteBuf buf, T value) {
            if (!this.synced) {
                return;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            this.write(nbt, value);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
        }

        @Override
        public T read(ByteBuf buf) {
            if (!this.synced) {
                return null;
            }
            NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
            if (nbt == null) {
                return null;
            }
            return this.read(nbt);
        }

        public static StoredVariable<Byte, NBTTagByte> ofByte(String key, Persistence persistence) {
            return new StoredVariable<Byte, NBTTagByte>(key, NBTTagByte::new, NBTTagByte::func_150290_f, persistence);
        }

        public static StoredVariable<Boolean, NBTTagByte> ofBoolean(String key, Persistence persistence) {
            return new StoredVariable<Boolean, NBTTagByte>(key, b -> new NBTTagByte((byte)(b != false ? 1 : 0)), t -> t.func_150290_f() == 1, persistence);
        }

        public static StoredVariable<Integer, NBTTagInt> ofInt(String key, Persistence persistence) {
            return new StoredVariable<Integer, NBTTagInt>(key, NBTTagInt::new, NBTTagInt::func_150287_d, persistence);
        }

        public static StoredVariable<int[], NBTTagIntArray> ofIntArray(String key, Persistence persistence) {
            return new StoredVariable<int[], NBTTagIntArray>(key, NBTTagIntArray::new, NBTTagIntArray::func_150302_c, persistence);
        }

        public static StoredVariable<Float, NBTTagFloat> ofFloat(String key, Persistence persistence) {
            return new StoredVariable<Float, NBTTagFloat>(key, NBTTagFloat::new, NBTTagFloat::func_150288_h, persistence);
        }

        public static StoredVariable<Double, NBTTagDouble> ofDouble(String key, Persistence persistence) {
            return new StoredVariable<Double, NBTTagDouble>(key, NBTTagDouble::new, NBTTagDouble::func_150286_g, persistence);
        }

        public static StoredVariable<Short, NBTTagShort> ofShort(String key, Persistence persistence) {
            return new StoredVariable<Short, NBTTagShort>(key, NBTTagShort::new, NBTTagShort::func_150289_e, persistence);
        }

        public static StoredVariable<Long, NBTTagLong> ofLong(String key, Persistence persistence) {
            return new StoredVariable<Long, NBTTagLong>(key, NBTTagLong::new, NBTTagLong::func_150291_c, persistence);
        }

        public static StoredVariable<String, NBTTagString> ofString(String key, Persistence persistence) {
            return new StoredVariable<String, NBTTagString>(key, NBTTagString::new, NBTTagString::func_150285_a_, persistence);
        }

        public static StoredVariable<BlockPos, NBTTagCompound> ofBlockPos(String key, Persistence persistence) {
            return new StoredVariable<BlockPos, NBTTagCompound>(key, NBTUtil::func_186859_a, NBTUtil::func_186861_c, persistence);
        }

        public static StoredVariable<UUID, NBTTagCompound> ofUUID(String key, Persistence persistence) {
            return new StoredVariable<UUID, NBTTagCompound>(key, NBTUtil::func_186862_a, NBTUtil::func_186860_b, persistence);
        }

        public static StoredVariable<ItemStack, NBTTagCompound> ofItemStack(String key, Persistence persistence) {
            return new StoredVariable<ItemStack, NBTTagCompound>(key, ItemStack::serializeNBT, ItemStack::new, persistence);
        }

        public static StoredVariable<NBTTagCompound, NBTTagCompound> ofNBT(String key, Persistence persistence) {
            return new StoredVariable<NBTTagCompound, NBTTagCompound>(key, t -> t, t -> t, persistence);
        }
    }
}

