/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.command;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.command.SpellEmitter;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.PacketCastSpellAtPos;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandCastSpell
extends CommandBase {
    public static final int DEFAULT_CASTING_DURATION = 100;
    public static final int MIN_CASTING_DURATION = 0;
    public static final int MAX_CASTING_DURATION = 1000000;

    public String func_71517_b() {
        return Wizardry.settings.castCommandName;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ebwizardry:cast.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] arguments, BlockPos pos) {
        switch (arguments.length) {
            case 1: {
                return CommandCastSpell.func_175762_a((String[])arguments, Spell.getSpellNames());
            }
            case 2: {
                return CommandCastSpell.func_71530_a((String[])arguments, (String[])server.func_71213_z());
            }
        }
        return super.func_184883_a(server, sender, arguments, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] arguments) throws CommandException {
        if (arguments.length < 1) {
            throw new WrongUsageException("commands.ebwizardry:cast.usage", new Object[]{Wizardry.settings.castCommandName});
        }
        int i = 0;
        EntityPlayerMP caster = null;
        Vec3d origin = null;
        EnumFacing direction = null;
        try {
            caster = CommandCastSpell.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException playerNotFoundException) {
            // empty catch block
        }
        Spell spell = Spell.get(arguments[i++]);
        if (spell == null) {
            throw new NumberInvalidException("commands.ebwizardry:cast.not_found", new Object[]{arguments[i - 1]});
        }
        boolean castAsOtherPlayer = false;
        if (i + 3 < arguments.length) {
            Vec3d vec3d = sender.func_174791_d();
            CommandBase.CoordinateArg x = CommandCastSpell.func_175770_a((double)vec3d.field_72450_a, (String)arguments[i++], (boolean)true);
            CommandBase.CoordinateArg y = CommandCastSpell.func_175767_a((double)vec3d.field_72448_b, (String)arguments[i++], (int)0, (int)256, (boolean)false);
            CommandBase.CoordinateArg z = CommandCastSpell.func_175770_a((double)vec3d.field_72449_c, (String)arguments[i++], (boolean)true);
            origin = new Vec3d(x.func_179628_a(), y.func_179628_a(), z.func_179628_a());
            if ((direction = EnumFacing.func_176739_a((String)arguments[i++])) == null) {
                throw new NumberInvalidException("commands.ebwizardry:cast.invalid_direction", new Object[]{arguments[i - 1]});
            }
        } else if (i < arguments.length) {
            try {
                EntityPlayerMP entityplayermp = CommandCastSpell.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)arguments[i++]);
                if (caster != entityplayermp) {
                    castAsOtherPlayer = true;
                    caster = entityplayermp;
                }
            }
            catch (PlayerNotFoundException exception) {
                --i;
            }
        }
        if (caster == null && origin == null) {
            throw new PlayerNotFoundException("commands.ebwizardry:cast.origin_not_specified");
        }
        int duration = 100;
        int seconds = duration / 20;
        if (spell.isContinuous) {
            if (i >= arguments.length) {
                throw new CommandException("commands.ebwizardry:cast.duration_not_specified", new Object[0]);
            }
            try {
                seconds = CommandCastSpell.func_175755_a((String)arguments[i++]);
            }
            catch (NumberInvalidException e) {
                --i;
            }
            if (seconds < 0) {
                throw new NumberInvalidException("commands.generic.num.tooSmall", new Object[]{seconds, 0});
            }
            if (seconds > 1000000) {
                throw new NumberInvalidException("commands.generic.num.tooBig", new Object[]{seconds, 1000000});
            }
            duration = seconds * 20;
        }
        SpellModifiers modifiers = new SpellModifiers();
        if (i < arguments.length) {
            String nbt = CommandCastSpell.func_147178_a((ICommandSender)sender, (String[])arguments, (int)i++).func_150260_c();
            try {
                modifiers = SpellModifiers.fromNBT(JsonToNBT.func_180713_a((String)nbt));
            }
            catch (NBTException nbtexception) {
                throw new CommandException("commands.ebwizardry:cast.tag_error", new Object[]{nbtexception.getMessage()});
            }
            for (float multiplier : modifiers.getModifiers().values()) {
                if (multiplier < 0.0f) {
                    throw new NumberInvalidException("commands.generic.double.tooSmall", new Object[]{Float.valueOf(multiplier), 0});
                }
                if (!((double)multiplier > Wizardry.settings.maxSpellCommandMultiplier)) continue;
                throw new NumberInvalidException("commands.generic.double.tooBig", new Object[]{Float.valueOf(multiplier), Wizardry.settings.maxSpellCommandMultiplier});
            }
        }
        if (origin != null) {
            PacketCastSpellAtPos.Message msg;
            World world = sender.func_130014_f_();
            if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.COMMAND, spell, world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, direction, modifiers))) {
                if (server.func_174792_t_()) {
                    this.displayFailMessage(sender, spell);
                }
                return;
            }
            if (spell.isContinuous) {
                if (spell.cast(world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, direction, 0, duration, modifiers)) {
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, direction, modifiers));
                    SpellEmitter.add(spell, world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, direction, duration, modifiers);
                    msg = new PacketCastSpellAtPos.Message(origin, direction, spell, modifiers, duration);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                    if (server.func_174792_t_()) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:cast.success_position_continuous", new Object[]{spell.getNameForTranslationFormatted(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, seconds}));
                    }
                    return;
                }
            } else if (spell.cast(world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, direction, 0, -1, modifiers)) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, world, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, direction, modifiers));
                if (spell.requiresPacket()) {
                    msg = new PacketCastSpellAtPos.Message(origin, direction, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                if (server.func_174792_t_()) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:cast.success_position", new Object[]{spell.getNameForTranslationFormatted(), origin.field_72450_a, origin.field_72448_b, origin.field_72449_c}));
                }
                return;
            }
        } else {
            if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.COMMAND, spell, (EntityLivingBase)caster, modifiers))) {
                if (server.func_174792_t_()) {
                    this.displayFailMessage(sender, spell);
                }
                return;
            }
            if (spell.isContinuous) {
                WizardData data = WizardData.get((EntityPlayer)caster);
                if (data != null) {
                    if (data.isCasting()) {
                        data.stopCastingContinuousSpell();
                    } else {
                        data.startCastingContinuousSpell(spell, modifiers, duration);
                        if (server.func_174792_t_()) {
                            if (castAsOtherPlayer) {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:cast.success_remote_continuous", new Object[]{spell.getNameForTranslationFormatted(), caster.func_70005_c_(), seconds}));
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:cast.success_continuous", new Object[]{spell.getNameForTranslationFormatted(), seconds}));
                            }
                        }
                    }
                    return;
                }
            } else if (spell.cast(caster.field_70170_p, (EntityPlayer)caster, EnumHand.MAIN_HAND, 0, modifiers)) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, (EntityLivingBase)caster, modifiers));
                if (spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), null, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, caster.field_70170_p.field_73011_w.getDimension());
                }
                if (server.func_174792_t_()) {
                    if (castAsOtherPlayer) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:cast.success_remote", new Object[]{spell.getNameForTranslationFormatted(), caster.func_70005_c_()}));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ebwizardry:cast.success", new Object[]{spell.getNameForTranslationFormatted()}));
                    }
                }
                return;
            }
        }
        if (server.func_174792_t_()) {
            this.displayFailMessage(sender, spell);
        }
    }

    private void displayFailMessage(ICommandSender sender, Spell spell) {
        TextComponentTranslation message = new TextComponentTranslation("commands.ebwizardry:cast.fail", new Object[]{spell.getNameForTranslationFormatted()});
        message.func_150256_b().func_150238_a(TextFormatting.RED);
        sender.func_145747_a((ITextComponent)message);
    }
}

