/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.particle;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.particle.ParticleWizardry;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class ParticleTargeted
extends ParticleWizardry {
    private static final double THIRD_PERSON_AXIAL_OFFSET = 1.2;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double targetVelX;
    protected double targetVelY;
    protected double targetVelZ;
    protected double length;
    @Nullable
    protected Entity target = null;

    public ParticleTargeted(World world, double x, double y, double z, ResourceLocation ... textures) {
        super(world, x, y, z, textures);
    }

    @Override
    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    @Override
    public void setTargetVelocity(double vx, double vy, double vz) {
        this.targetVelX = vx;
        this.targetVelY = vy;
        this.targetVelZ = vz;
    }

    @Override
    public void setTargetEntity(Entity target) {
        this.target = target;
    }

    @Override
    public void setLength(double length) {
        this.length = length;
    }

    @Override
    public void func_189213_a() {
        super.func_189213_a();
        if (!(Double.isNaN(this.targetVelX) || Double.isNaN(this.targetVelY) || Double.isNaN(this.targetVelZ))) {
            this.targetX += this.targetVelX;
            this.targetY += this.targetVelY;
            this.targetZ += this.targetVelZ;
        }
    }

    @Override
    public void func_180434_a(BufferBuilder buffer, Entity viewer, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Vec3d look;
        this.updateEntityLinking(viewer, partialTicks);
        float x = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks);
        float y = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks);
        float z = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks);
        if (this.entity != null && this.shouldApplyOriginOffset() && (this.entity != viewer || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0)) {
            look = this.entity.func_70676_i(partialTicks).func_186678_a(1.2);
            x = (float)((double)x + look.field_72450_a);
            y = (float)((double)y + look.field_72448_b);
            z = (float)((double)z + look.field_72449_c);
        }
        if (this.target != null) {
            this.targetX = this.target.field_70169_q + (this.target.field_70165_t - this.target.field_70169_q) * (double)partialTicks;
            double correction = this.target.field_70163_u - this.target.field_70163_u;
            this.targetY = this.target.field_70167_r + (this.target.field_70163_u - this.target.field_70167_r) * (double)partialTicks + (double)(this.target.field_70131_O / 2.0f) + correction;
            this.targetZ = this.target.field_70166_s + (this.target.field_70161_v - this.target.field_70166_s) * (double)partialTicks;
        } else if (this.entity != null && this.length > 0.0) {
            look = this.entity.func_70676_i(partialTicks).func_186678_a(this.length);
            this.targetX = (double)x + look.field_72450_a;
            this.targetY = (double)y + look.field_72448_b;
            this.targetZ = (double)z + look.field_72449_c;
        }
        if (Double.isNaN(this.targetX) || Double.isNaN(this.targetY) || Double.isNaN(this.targetZ)) {
            Wizardry.logger.warn("Attempted to render a targeted particle, but neither its target entity nor targetposition was set, and it either had no length assigned or was not linked to an entity!");
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)x - field_70556_an), (double)((double)y - field_70554_ao), (double)((double)z - field_70555_ap));
        double dx = this.targetX - (double)x;
        double dy = this.targetY - (double)y;
        double dz = this.targetZ - (double)z;
        if (!(Double.isNaN(this.targetVelX) || Double.isNaN(this.targetVelY) || Double.isNaN(this.targetVelZ))) {
            dx += (double)partialTicks * this.targetVelX;
            dy += (double)partialTicks * this.targetVelY;
            dz += (double)partialTicks * this.targetVelZ;
        }
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        float yaw = (float)(57.29577951308232 * Math.atan2(dx, dz));
        float pitch = (float)(57.2957763671875 * Math.atan(-dy / Math.sqrt(dz * dz + dx * dx)));
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        this.draw(tessellator, length, partialTicks);
        GlStateManager.func_179121_F();
    }

    protected boolean shouldApplyOriginOffset() {
        return true;
    }

    protected abstract void draw(Tessellator var1, double var2, float var4);
}

