/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.model;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockCrystal;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.client.model.BakedModelGlowingOverlay;
import electroblob.wizardry.client.model.ModelLoaderBookshelf;
import electroblob.wizardry.item.IMultiTexturedItem;
import electroblob.wizardry.item.ItemBlockMultiTextured;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemSpectralDust;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class WizardryModels {
    private static final List<Item> registeredItems = new ArrayList<Item>();

    private WizardryModels() {
    }

    @SubscribeEvent
    public static void register(ModelRegistryEvent event) {
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.crystal_block, (IStateMapper)new StateMap.Builder().func_178440_a(BlockCrystal.ELEMENT).func_178439_a("_crystal_block").func_178441_a());
        ItemBlockMultiTextured crystalBlockItem = (ItemBlockMultiTextured)Item.func_150898_a((Block)WizardryBlocks.crystal_block);
        WizardryModels.registerMultiTexturedModel(crystalBlockItem);
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.runestone, (IStateMapper)new StateMap.Builder().func_178440_a(BlockRunestone.ELEMENT).func_178439_a("_runestone").func_178441_a());
        ItemBlockMultiTextured runestoneItem = (ItemBlockMultiTextured)Item.func_150898_a((Block)WizardryBlocks.runestone);
        WizardryModels.registerMultiTexturedModel(runestoneItem);
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.runestone_pedestal, (IStateMapper)new StateMap.Builder().func_178440_a(BlockPedestal.ELEMENT).func_178442_a(new IProperty[]{BlockPedestal.NATURAL}).func_178439_a("_runestone_pedestal").func_178441_a());
        ItemBlockMultiTextured pedestalItem = (ItemBlockMultiTextured)Item.func_150898_a((Block)WizardryBlocks.runestone_pedestal);
        WizardryModels.registerMultiTexturedModel(pedestalItem);
        ModelLoader.setCustomStateMapper((Block)WizardryBlocks.gilded_wood, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockPlanks.field_176383_a).func_178439_a("_gilded_wood").func_178441_a());
        ItemBlockMultiTextured gildedWoodItem = (ItemBlockMultiTextured)Item.func_150898_a((Block)WizardryBlocks.gilded_wood);
        WizardryModels.registerMultiTexturedModel(gildedWoodItem);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderBookshelf());
        WizardryModels.registerMultiTexturedModel((ItemCrystal)WizardryItems.magic_crystal);
        WizardryModels.registerWandModel(WizardryItems.magic_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_wand);
        WizardryModels.registerWandModel(WizardryItems.master_wand);
        WizardryModels.registerItemModel(WizardryItems.spell_book);
        WizardryModels.registerItemModel(WizardryItems.spell_book, Short.MAX_VALUE, "normal");
        WizardryModels.registerWandModel(WizardryItems.novice_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.novice_healing_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.apprentice_healing_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.advanced_healing_wand);
        WizardryModels.registerWandModel(WizardryItems.master_fire_wand);
        WizardryModels.registerWandModel(WizardryItems.master_ice_wand);
        WizardryModels.registerWandModel(WizardryItems.master_lightning_wand);
        WizardryModels.registerWandModel(WizardryItems.master_necromancy_wand);
        WizardryModels.registerWandModel(WizardryItems.master_earth_wand);
        WizardryModels.registerWandModel(WizardryItems.master_sorcery_wand);
        WizardryModels.registerWandModel(WizardryItems.master_healing_wand);
        WizardryModels.registerMultiTexturedModel((ItemSpectralDust)WizardryItems.spectral_dust);
        for (Item item : Item.field_150901_e) {
            if (registeredItems.contains(item) || !item.getRegistryName().func_110624_b().equals("ebwizardry")) continue;
            WizardryModels.registerItemModel(item);
        }
        registeredItems.clear();
    }

    @SubscribeEvent
    public static void bake(ModelBakeEvent event) {
        for (ModelResourceLocation location : event.getModelRegistry().func_148742_b()) {
            if (!location.func_110624_b().equals("ebwizardry")) continue;
            IBakedModel original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
            if (location.func_110623_a().contains("runestone") || location.func_110623_a().contains("runestone_pedestal") || location.func_110623_a().endsWith("imbuement_altar")) {
                event.getModelRegistry().func_82595_a((Object)location, (Object)new BakedModelGlowingOverlay(original, "overlay"));
                continue;
            }
            if (!location.func_110623_a().contains("spectral_block")) continue;
            event.getModelRegistry().func_82595_a((Object)location, (Object)new BakedModelGlowingOverlay(original, "spectral_block"));
        }
    }

    private static void registerItemModel(Item item) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(item.getRegistryName(), "inventory")});
        ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation(item.getRegistryName(), "inventory"));
        registeredItems.add(item);
    }

    private static void registerWandModel(Item item) {
        if (Wizardry.tisTheSeason) {
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("ebwizardry:festive_wand", "inventory")});
            ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation("ebwizardry:festive_wand", "inventory"));
            registeredItems.add(item);
        } else {
            WizardryModels.registerItemModel(item);
        }
    }

    private static <T extends Item> void registerMultiTexturedModel(T item) {
        if (item.func_77614_k()) {
            NonNullList items = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), items);
            for (ItemStack stack : items) {
                ModelLoader.setCustomModelResourceLocation(item, (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(((IMultiTexturedItem)item).getModelName(stack), "inventory"));
            }
        }
        registeredItems.add(item);
    }

    private static void registerItemModel(Item item, int metadata, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
        registeredItems.add(item);
    }
}

