/*
 * Decompiled with CFR 0.152.
 */
package com.jarhax.eerieentities.client;

import com.jarhax.eerieentities.client.ClientEvents;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderHandler {
    public static final int VERT = 35633;
    public static final int FRAG = 35632;
    public static int WISP;

    public static void registerShaders() {
        try {
            WISP = ShaderHandler.create("/assets/eerieentities/shaders/wisp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void useShader(int shader, Map<String, Object> data) {
        if (!ShaderHandler.useShaders()) {
            return;
        }
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (shader != 0) {
            int time = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            ARBShaderObjects.glUniform1fARB((int)time, (float)ClientEvents.totalTime);
            int res = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"resolution");
            ARBShaderObjects.glUniform3iARB((int)res, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d, (int)0);
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                int id = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)entry.getKey());
                if (entry.getValue() instanceof Float) {
                    ARBShaderObjects.glUniform1fARB((int)id, (float)((Float)entry.getValue()).floatValue());
                }
                if (!(entry.getValue() instanceof Integer)) continue;
                ARBShaderObjects.glUniform1iARB((int)id, (int)((Integer)entry.getValue()));
            }
        }
    }

    public static void userShader(int shader) {
        ShaderHandler.useShader(shader, new HashMap<String, Object>());
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static void releaseShader() {
        ShaderHandler.useShader(0, new HashMap<String, Object>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int create(String location) {
        int fragShader = 0;
        int program = 0;
        try {
            fragShader = ShaderHandler.createShader(location + ".frag", 35632);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            int n = 0;
            return n;
        }
        program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program == 0) {
            return 0;
        }
        ARBShaderObjects.glAttachObjectARB((int)program, (int)fragShader);
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            System.err.println(ShaderHandler.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            System.err.println(ShaderHandler.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)IOUtils.toString((InputStream)ShaderHandler.class.getResourceAsStream(filename)));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ShaderHandler.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }
}

