/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.world.gen.generators;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.util.interfaces.IStructure;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class WorldGenStructure
extends WorldGenerator
implements IStructure {
    public String structureName;
    public List<Biome> allowedBiomes = null;

    public WorldGenStructure(String name) {
        this.structureName = name;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("dungeonsmod", this.structureName + "_noblock"));
        if (template != null) {
            IBlockState state = world.func_180495_p(position);
            world.func_184138_a(position, state, state, 3);
            template.func_186253_b(world, position, settings);
            this.handleMetadata(world, template, position);
        }
        return true;
    }

    public BlockPos findBiomePos(World world, BlockPos initialPos) {
        BlockPos genPos = BlockPos.field_177992_a;
        boolean founded = false;
        int tries1 = 0;
        int maxTries = 5;
        while (!founded && ++tries1 <= maxTries) {
            if (genPos == BlockPos.field_177992_a) {
                EnumFacing direction = EnumFacing.UP;
                int length = 0;
                int centerOffset = 5;
                int sampleSpace = 1 + (tries1 - 1) * 10;
                int nextLength = 1;
                int x = (initialPos.func_177958_n() >> 4) - centerOffset * nextLength;
                int z = (initialPos.func_177952_p() >> 4) + centerOffset * nextLength;
                nextLength += centerOffset * 2 * nextLength;
                int tries = 1000;
                while (--tries > 0) {
                    if (direction == EnumFacing.NORTH) {
                        z -= sampleSpace;
                    } else if (direction == EnumFacing.EAST) {
                        x += sampleSpace;
                    } else if (direction == EnumFacing.SOUTH) {
                        z += sampleSpace;
                    } else if (direction == EnumFacing.WEST) {
                        x -= sampleSpace;
                    }
                    BlockPos pos = new BlockPos((x << 4) + 8, 80, (z << 4) + 8);
                    boolean generated = world.func_72863_F().func_191062_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
                    Biome biomeAtPos = world.getBiomeForCoordsBody(pos);
                    if (generated) {
                        // empty if block
                    }
                    if (this.allowedBiomes.contains(biomeAtPos) && !generated && world.func_72959_q().func_76940_a(pos.func_177958_n(), pos.func_177952_p(), 40, this.allowedBiomes)) {
                        DungeonsMod.logger.info("Coal 2>> /tp {} {} {}", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
                        genPos = new BlockPos(x << 4, 20, z << 4);
                        tries = 0;
                    }
                    if ((length += sampleSpace) >= nextLength) {
                        if (direction != EnumFacing.UP) {
                            if (direction == EnumFacing.EAST || direction == EnumFacing.WEST) {
                                nextLength += sampleSpace;
                            }
                            direction = direction.func_176746_e();
                        } else {
                            direction = EnumFacing.NORTH;
                        }
                        length = 0;
                    }
                    if (tries1 < maxTries) continue;
                    sampleSpace = tries;
                }
            }
            if (!genPos.equals((Object)BlockPos.field_177992_a)) {
                founded = true;
                continue;
            }
            founded = false;
        }
        return genPos;
    }

    private StructureBoundingBox setBoundingBoxFromTemplate(Template template, BlockPos templatePosition) {
        Rotation rotation = settings.func_186215_c();
        BlockPos blockpos = template.func_186257_a(rotation);
        Mirror mirror = settings.func_186212_b();
        StructureBoundingBox box = new StructureBoundingBox(0, 0, 0, blockpos.func_177958_n(), blockpos.func_177956_o() - 1, blockpos.func_177952_p());
        switch (rotation) {
            default: {
                break;
            }
            case CLOCKWISE_90: {
                box.func_78886_a(-blockpos.func_177958_n(), 0, 0);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                box.func_78886_a(0, 0, -blockpos.func_177952_p());
                break;
            }
            case CLOCKWISE_180: {
                box.func_78886_a(-blockpos.func_177958_n(), 0, -blockpos.func_177952_p());
            }
        }
        switch (mirror) {
            default: {
                break;
            }
            case FRONT_BACK: {
                BlockPos blockpos2 = BlockPos.field_177992_a;
                blockpos2 = rotation != Rotation.CLOCKWISE_90 && rotation != Rotation.COUNTERCLOCKWISE_90 ? (rotation == Rotation.CLOCKWISE_180 ? blockpos2.func_177967_a(EnumFacing.EAST, blockpos.func_177958_n()) : blockpos2.func_177967_a(EnumFacing.WEST, blockpos.func_177958_n())) : blockpos2.func_177967_a(rotation.func_185831_a(EnumFacing.WEST), blockpos.func_177952_p());
                box.func_78886_a(blockpos2.func_177958_n(), 0, blockpos2.func_177952_p());
                break;
            }
            case LEFT_RIGHT: {
                BlockPos blockpos1 = BlockPos.field_177992_a;
                blockpos1 = rotation != Rotation.CLOCKWISE_90 && rotation != Rotation.COUNTERCLOCKWISE_90 ? (rotation == Rotation.CLOCKWISE_180 ? blockpos1.func_177967_a(EnumFacing.SOUTH, blockpos.func_177952_p()) : blockpos1.func_177967_a(EnumFacing.NORTH, blockpos.func_177952_p())) : blockpos1.func_177967_a(rotation.func_185831_a(EnumFacing.NORTH), blockpos.func_177958_n());
                box.func_78886_a(blockpos1.func_177958_n(), 0, blockpos1.func_177952_p());
            }
        }
        box.func_78886_a(templatePosition.func_177958_n(), templatePosition.func_177956_o(), templatePosition.func_177952_p());
        return box;
    }

    public void generateStructure(World world, Random random, int chunkX, int chunkZ) {
        BlockPos blockPos = this.shouldStartAt(world, random, chunkX, chunkZ);
        if (blockPos != BlockPos.field_177992_a) {
            this.func_180709_b(world, random, blockPos);
        }
    }

    public void notifyAllBlocksAdequately(World world, Template template, BlockPos pos) {
        StructureBoundingBox box = this.setBoundingBoxFromTemplate(template, pos);
    }

    public abstract BlockPos shouldStartAt(World var1, Random var2, int var3, int var4);

    public abstract BlockPos findStructurePos(World var1, BlockPos var2);

    public abstract void handleMetadata(World var1, Template var2, BlockPos var3);
}

