/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.util.handlers;

import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.init.ProfessionsInit;
import com.dainxt.dungeonsmod.util.Location;
import com.dainxt.dungeonsmod.util.TeleportHelper;
import com.dainxt.dungeonsmod.util.handlers.ConfigHandler;
import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventsHandler {
    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && event.getSource().func_76347_k() && entity.field_71093_bK == -1) {
            AxisAlignedBB box;
            List suns;
            ItemStack hand;
            EntityPlayer player = (EntityPlayer)entity;
            World world = player.field_70170_p;
            if (player.func_110143_aJ() <= 6.0f && player.func_70658_aO() <= 6 && (hand = player.func_184614_ca()).func_190916_E() == 6 && Block.func_149634_a((Item)hand.func_77973_b()).equals(Blocks.field_150339_S) && player.func_70027_ad() && (suns = world.func_72872_a(EntitySun.class, box = new AxisAlignedBB(new BlockPos(player.field_70165_t, player.field_70163_u + 40.0, player.field_70161_v)).func_186662_g(10.0))).isEmpty() && !world.field_72995_K) {
                EntitySun sun = new EntitySun(world);
                sun.func_70012_b(player.field_70165_t, player.field_70163_u + 40.0, player.field_70161_v, 0.0f, 0.0f);
                world.func_72838_d((Entity)sun);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_77973_b() == Items.field_151055_y && !event.getWorld().field_72995_K) {
            AxisAlignedBB box = new AxisAlignedBB(event.getPos()).func_186662_g(10.0);
            World world = event.getWorld();
            if (event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                List kings = world.func_72872_a(Entity.class, box);
                if (!kings.isEmpty() && !world.field_72995_K) {
                    boolean counter = false;
                    for (Entity entity : kings) {
                    }
                }
            }
        }
        if (event.getItemStack().func_77973_b() == Items.field_151033_d) {
            BlockPos initialPos = event.getPos();
            Block block = event.getWorld().func_180495_p(initialPos).func_177230_c();
            if (block == Blocks.field_150402_ci && event.getFace().equals((Object)EnumFacing.UP) && !event.getWorld().field_72995_K) {
                World world = event.getWorld();
                EventsHandler.invokeTraveler(world, initialPos);
            }
        }
    }

    @SubscribeEvent
    public void onEntityPlace(BlockEvent.EntityPlaceEvent e) {
        AxisAlignedBB box = new AxisAlignedBB(e.getPos()).func_186662_g(10.0);
        World world = e.getWorld();
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            List kings = world.func_72872_a(EntityKing.class, box);
            if (!kings.isEmpty() && !world.field_72995_K) {
                for (EntityKing king : kings) {
                    king.DESTROY_BLOCKS_2.put(e.getPos(), e.getState());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityBreak(BlockEvent.BreakEvent e) {
        AxisAlignedBB box = new AxisAlignedBB(e.getPos()).func_186662_g(10.0);
        World world = e.getWorld();
        EntityPlayer player = e.getPlayer();
        List kings = world.func_72872_a(EntityKing.class, box);
        if (!kings.isEmpty() && !world.field_72995_K) {
            for (EntityKing king : kings) {
                king.FIX_BLOCKS_2.put(e.getPos(), e.getState());
            }
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("dungeonsmod")) {
            ConfigManager.sync((String)"dungeonsmod", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    public static void invokeTraveler(World world, BlockPos initialPos) {
        AxisAlignedBB box = new AxisAlignedBB(initialPos).func_186662_g((double)ConfigHandler.traveler.oneRange);
        if (world.func_175647_a(EntityVillager.class, box, (Predicate)new TravelerSelector()).isEmpty()) {
            EntityVillager traveler = new EntityVillager(world);
            traveler.setProfession(ProfessionsInit.TRAVELER);
            int xSign = world.field_73012_v.nextBoolean() ? 1 : -1;
            int zSign = world.field_73012_v.nextBoolean() ? 1 : -1;
            int initialSpawnPosX = (int)((double)initialPos.func_177958_n() + 4.0 * (double)xSign);
            int initialSpawnPosZ = (int)((double)initialPos.func_177952_p() + 4.0 * (double)zSign);
            int initSpawnY = WorldGenCustomStructures.calculateGenerationHeight(world, initialSpawnPosX, initialSpawnPosZ, new Block[0]);
            traveler.func_70012_b((double)initialPos.func_177958_n() + 4.0 * (double)xSign, (double)initSpawnY + 1.0, (double)initialPos.func_177952_p() + 4.0 * (double)zSign, 0.0f, 0.0f);
            world.func_72838_d((Entity)traveler);
        }
    }

    @SubscribeEvent
    public void onDeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            TeleportHelper.playerBackMap.put(player, new Location(event.getEntity().func_180425_c(), event.getEntity().field_71093_bK));
        }
    }

    public static class TravelerSelector
    implements Predicate<EntityVillager> {
        public boolean apply(@Nullable EntityVillager p_apply_1_) {
            return p_apply_1_.getProfessionForge().equals(ProfessionsInit.TRAVELER);
        }
    }
}

