/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.init;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.entity.EntityAnthermite;
import com.dainxt.dungeonsmod.entity.EntityMimic;
import com.dainxt.dungeonsmod.entity.EntityPiranha;
import com.dainxt.dungeonsmod.entity.EntityRogue;
import com.dainxt.dungeonsmod.entity.EntityShark;
import com.dainxt.dungeonsmod.entity.EntitySlimond;
import com.dainxt.dungeonsmod.entity.EntityTraveler;
import com.dainxt.dungeonsmod.entity.boss.EntityCrawler;
import com.dainxt.dungeonsmod.entity.boss.EntityDeserted;
import com.dainxt.dungeonsmod.entity.boss.EntityIronSlime;
import com.dainxt.dungeonsmod.entity.boss.EntityKing;
import com.dainxt.dungeonsmod.entity.boss.EntityKraken;
import com.dainxt.dungeonsmod.entity.boss.EntityPhoenix;
import com.dainxt.dungeonsmod.entity.boss.EntityRefractor;
import com.dainxt.dungeonsmod.entity.boss.EntitySun;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon4.EntityGuard;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon4.EntityNinja;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntityScientist;
import com.dainxt.dungeonsmod.entity.dungeons.dungeon5.EntitySlimewolf;
import com.dainxt.dungeonsmod.util.handlers.ConfigHandler;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityInit {
    public static void registerEntities() {
        HashSet<Biome> validBiomes = new HashSet<Biome>();
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS));
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
        EntityInit.registerEntityWithSpawn("Rogue", 120, EntityRogue.class, ConfigHandler.spawnRates.Rogue, 3, 7, EnumCreatureType.CREATURE, validBiomes);
        EntityInit.registerEntityWithSpawn("Anthermite", 123, EntityAnthermite.class, ConfigHandler.spawnRates.Anthermite, 3, 7, EnumCreatureType.CREATURE, validBiomes);
        EntityInit.registerEntityWithSpawn("Mimic", 131, EntityMimic.class, ConfigHandler.spawnRates.Mimic, 3, 7, EnumCreatureType.MONSTER, validBiomes);
        EntityInit.registerEntityWithSpawn("Crawler", 133, EntityCrawler.class, ConfigHandler.spawnRates.Crawler, 1, 1, EnumCreatureType.MONSTER, validBiomes);
        EntityInit.registerEntityWithSpawn("Slimond", 134, EntitySlimond.class, ConfigHandler.spawnRates.Slimond, 1, 1, EnumCreatureType.MONSTER, validBiomes);
        validBiomes.clear();
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WATER));
        EntityInit.registerEntityWithSpawn("Piranha", 125, EntityPiranha.class, ConfigHandler.spawnRates.Piranha, 2, 3, EnumCreatureType.WATER_CREATURE, validBiomes);
        EntityInit.registerEntity("Shark", EntityShark.class, 129, 100, 11437146, 1143714);
        validBiomes.clear();
        validBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        EntityInit.registerEntityWithSpawn("Kraken", 126, EntityKraken.class, ConfigHandler.spawnRates.Kraken, 1, 1, EnumCreatureType.WATER_CREATURE, validBiomes);
        validBiomes.clear();
        EntityInit.registerEntity("King", EntityKing.class, 127, 100, 11437146, 11437146);
        EntityInit.registerEntity("Deserted", EntityDeserted.class, 121, 100, 11437146, 11437146);
        EntityInit.registerEntity("Traveler", EntityTraveler.class, 122, 100, 11437146, 11437146);
        EntityInit.registerEntity("IronSlime", EntityIronSlime.class, 124, 100, 11437146, 11437146);
        EntityInit.registerEntity("KingGuard", EntityGuard.class, 128, 100, 11437146, 11437146);
        EntityInit.registerEntity("Ninja", EntityNinja.class, 130, 100, 11437146, 11437146);
        EntityInit.registerEntity("Refractor", EntityRefractor.class, 135, 100, 11437146, 11437146);
        EntityInit.registerEntity("Scientist", EntityScientist.class, 136, 100, 11437146, 11437146);
        EntityInit.registerEntity("Phoenix", EntityPhoenix.class, 137, 100, 11437146, 11437146);
        EntityInit.registerEntity("Sun", EntitySun.class, 138, 200, 11437146, 11437146);
        EntityInit.registerEntity("Slimewolf", EntitySlimewolf.class, 139, 200, 11437146, 11437146);
    }

    private static void registerEntity(String name, Class<? extends Entity> entity, int id, int range, int color1, int color2) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("dungeonsmod", name), entity, (String)name, (int)id, (Object)DungeonsMod.instance, (int)range, (int)1, (boolean)true, (int)color1, (int)color2);
    }

    private static void registerEntityWithSpawn(String name, int id, Class<? extends EntityLiving> entity, double weight, int min, int max, EnumCreatureType type, Set<Biome> validBiomes) {
        EntityInit.registerEntity(name, entity, id, 200, 11437146, 11437146);
        if (type.equals((Object)EnumCreatureType.WATER_CREATURE)) {
            EntitySpawnPlacementRegistry.setPlacementType(entity, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        }
        EntityRegistry.addSpawn(entity, (int)MathHelper.func_76123_f((float)((float)weight)), (int)min, (int)max, (EnumCreatureType)type, (Biome[])validBiomes.toArray(new Biome[validBiomes.size()]));
    }

    public static boolean rareSpawn(Random random, double weight, boolean flag) {
        int chance;
        if (flag && weight > 0.0 && weight < 1.0 && (chance = random.nextInt((int)Math.round(1.0 / weight))) != 0) {
            flag = false;
        }
        return flag;
    }
}

