/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.DungeonsMod;
import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.dainxt.dungeonsmod.world.storage.WorldCustomData;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityKing
extends EntityMob {
    private static final DataParameter<Boolean> REST = EntityDataManager.func_187226_a(EntityKing.class, (DataSerializer)DataSerializers.field_187198_h);
    final int MAX_HOME = 9;
    public ArrayList<BlockPos> SACRIFICE_PLACES;
    public Map<BlockPos, IBlockState> DESTROY_BLOCKS_2;
    public Map<BlockPos, IBlockState> FIX_BLOCKS_2;
    private static final DataParameter<Boolean> HEAVY_ATTACK = EntityDataManager.func_187226_a(EntityKing.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_WAITING_FOR_SACRIFICE = EntityDataManager.func_187226_a(EntityKing.class, (DataSerializer)DataSerializers.field_187198_h);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public AIReturnHome returnHome;

    public EntityKing(World worldIn) {
        super(worldIn);
        if (!worldIn.field_72995_K) {
            this.DESTROY_BLOCKS_2 = new ConcurrentHashMap<BlockPos, IBlockState>();
            this.FIX_BLOCKS_2 = new ConcurrentHashMap<BlockPos, IBlockState>();
            this.SACRIFICE_PLACES = new ArrayList();
        }
        this.func_70105_a(1.8f, 5.0f);
        this.field_70728_aV = 6000;
        this.func_110163_bv();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151013_M));
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151005_D));
        this.func_184642_a(EntityEquipmentSlot.OFFHAND, 0.0f);
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ItemHoe) {
            stack.func_77966_a(Enchantments.field_185304_p, 4);
        }
        return super.func_70099_a(stack, offsetY);
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        boolean isBlocking = false;
        if (entityIn instanceof EntityPlayer) {
            ItemStack itemstack1;
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
            if (!itemstack1.func_190926_b() && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                isBlocking = true;
            }
        }
        boolean flag = false;
        flag = this.isHeavyAttacking() ? entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), 20.0f) : (isBlocking ? entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), f) : entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f));
        EntityLivingBase a = (EntityLivingBase)entityIn;
        a.field_70159_w = 0.0;
        a.field_70181_x = 0.0;
        a.field_70179_y = 0.0;
        if (flag) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAVY_ATTACK, (Object)false);
        this.field_70180_af.func_187214_a(IS_WAITING_FOR_SACRIFICE, (Object)false);
        this.field_70180_af.func_187214_a(REST, (Object)true);
    }

    public boolean isHeavyAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(HEAVY_ATTACK);
    }

    public void setHeavyAttack(boolean attack) {
        this.func_184212_Q().func_187227_b(HEAVY_ATTACK, (Object)attack);
    }

    public boolean isWaitingSacrifice() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_WAITING_FOR_SACRIFICE);
    }

    public void setWaitingSacrifice(boolean attack) {
        this.func_184212_Q().func_187227_b(IS_WAITING_FOR_SACRIFICE, (Object)attack);
    }

    public boolean isResting() {
        return (Boolean)this.func_184212_Q().func_187225_a(REST);
    }

    public void setRest(boolean attack) {
        this.func_184212_Q().func_187227_b(REST, (Object)attack);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_70107_b((int)this.field_70165_t, this.field_70163_u, (int)this.field_70161_v);
        if (!this.func_110175_bO()) {
            this.func_175449_a(this.func_180425_c(), 9);
        }
        this.func_180481_a(difficulty);
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70020_e(NBTTagCompound compound) {
        BlockPos homePos = BlockPos.func_177969_a((long)compound.func_74763_f("HomePosition"));
        if (!homePos.equals((Object)BlockPos.field_177992_a)) {
            this.func_175449_a(homePos, 9);
        }
        this.setWaitingSacrifice(compound.func_74767_n("WaitSac"));
        this.setHeavyAttack(compound.func_74767_n("HeavyAttack"));
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound nbt = compound.func_74775_l("sacPos");
            for (int i = 0; i < nbt.func_74762_e("index"); ++i) {
                this.SACRIFICE_PLACES.add(BlockPos.func_177969_a((long)nbt.func_74763_f("sacrifice_" + i)));
            }
        }
        super.func_70020_e(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        if (this.func_110175_bO()) {
            compound.func_74772_a("HomePosition", this.func_180486_cf().func_177986_g());
        }
        compound.func_74757_a("WaitSac", this.isWaitingSacrifice());
        compound.func_74757_a("HeavyAttack", this.isHeavyAttacking());
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound nbt = compound.func_74775_l("sacPos");
            nbt.func_74768_a("index", this.SACRIFICE_PLACES.size());
            for (int i = 0; i < this.SACRIFICE_PLACES.size(); ++i) {
                nbt.func_74772_a("sacrifice_" + i, this.SACRIFICE_PLACES.get(i).func_177986_g());
            }
            compound.func_74782_a("sacPos", (NBTBase)nbt);
        }
        return super.func_189511_e(compound);
    }

    protected float func_175134_bD() {
        return this.isHeavyAttacking() ? 1.0f : super.func_175134_bD();
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.KING;
    }

    protected void func_184651_r() {
        this.returnHome = new AIReturnHome(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.returnHome);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIDoNothing(this, 100));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIDoHeavyAttack(this, 60, 2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 0.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityArrow) {
            ((EntityArrow)source.func_76364_f()).func_70240_a(0);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            // empty if block
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.setRest(false);
        }
        if (!this.DESTROY_BLOCKS_2.isEmpty()) {
            this.destroyPosInAABB(this.func_174813_aQ().func_186662_g(3.0), this.DESTROY_BLOCKS_2, true);
        }
        if (!this.FIX_BLOCKS_2.isEmpty()) {
            this.placePosInAABB(this.func_174813_aQ().func_186662_g(1.5), this.FIX_BLOCKS_2, true);
        }
        float distance = Float.MAX_VALUE;
        for (EntityPlayer player : this.bossInfo.func_186757_c()) {
            distance = Math.min(player.func_70032_d((Entity)this), distance);
            if (!(distance < 5.0f) || !(player.func_184607_cu().func_77973_b() instanceof ItemFood)) continue;
            player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_151518_m().func_76348_h(), player.func_110138_aP());
        }
        if (distance > 9.0f) {
            this.returnHome.forceUpdate();
            this.func_70691_i(25.0f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private void destroyPosInAABB(AxisAlignedBB axisBB, Map<BlockPos, IBlockState> blockPos, boolean shouldDrop) {
        for (Map.Entry<BlockPos, IBlockState> entrySet : blockPos.entrySet()) {
            if (!axisBB.func_72326_a(new AxisAlignedBB(entrySet.getKey()))) continue;
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.field_70170_p.func_175655_b(entrySet.getKey(), true);
            blockPos.remove(entrySet.getKey());
        }
    }

    private void placePosInAABB(AxisAlignedBB axisBB, Map<BlockPos, IBlockState> blockPos, boolean shouldDrop) {
        for (Map.Entry<BlockPos, IBlockState> entrySet : blockPos.entrySet()) {
            if (!axisBB.func_72326_a(new AxisAlignedBB(entrySet.getKey()))) continue;
            this.func_184609_a(EnumHand.MAIN_HAND);
            this.field_70170_p.func_175656_a(entrySet.getKey(), entrySet.getValue());
            blockPos.remove(entrySet.getKey());
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        WorldCustomData data = WorldCustomData.get(this.field_70170_p);
        data.dungeonData.resetData(WorldGenCustomStructures.THE_CASTLE);
    }

    public boolean goHome(float speed) {
        BlockPos pos = this.func_180486_cf();
        if (!this.func_180425_c().equals((Object)pos) && !this.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)speed)) {
            this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return new AxisAlignedBB(this.func_180486_cf()).func_72326_a(this.func_174813_aQ());
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_, Block ... blockList) {
        int i = MathHelper.func_76128_c((double)p_70972_1_.field_72340_a);
        int j = MathHelper.func_76128_c((double)p_70972_1_.field_72338_b);
        int k = MathHelper.func_76128_c((double)p_70972_1_.field_72339_c);
        int l = MathHelper.func_76128_c((double)p_70972_1_.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)p_70972_1_.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)p_70972_1_.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos)) continue;
                    if (!ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                        flag = true;
                        continue;
                    }
                    if (block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) {
                        for (Block blockInList : blockList) {
                            if (block == blockInList) {
                                flag1 = this.field_70170_p.func_175698_g(blockpos) || flag1;
                                continue;
                            }
                            flag = true;
                        }
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier));
        if (i > 0) {
            if (distance >= 6.0f) {
                this.func_70097_a(DamageSource.field_76379_h, i);
                if (this.func_184207_aI()) {
                    for (Entity entity : this.func_184182_bu()) {
                        entity.func_70097_a(DamageSource.field_76379_h, (float)i);
                    }
                }
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.func_185467_w();
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    class AIDoHeavyAttack
    extends EntityAIBase {
        int waitHome;
        int interval;
        int range;
        int ticksSinceLastAttack;
        EntityKing attacker;
        EntityLivingBase target;

        public AIDoHeavyAttack(EntityKing entity, int attackInterval, int range) {
            this.interval = attackInterval;
            this.range = range;
            this.attacker = entity;
            this.func_75248_a(3);
        }

        public void func_75251_c() {
            this.ticksSinceLastAttack = 0;
            this.attacker.setHeavyAttack(false);
            this.target = null;
        }

        public boolean isLooking(EntityLivingBase target) {
            DungeonsMod.logger.info("{}", (Object)this.attacker.func_70676_i(1.0f));
            return true;
        }

        public void func_75246_d() {
            if (this.target != null) {
                Vec3d vec1 = this.target.func_174791_d().func_72441_c(0.0, (double)this.target.func_70047_e(), 0.0);
                Vec3d vec2 = this.attacker.func_174791_d().func_72441_c(0.0, (double)this.attacker.func_70047_e(), 0.0);
                Vec3d direction = vec1.func_178788_d(vec2);
                this.attacker.func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
                if (!this.attacker.field_70703_bu && this.attacker.field_70122_E) {
                    if (this.attacker.goHome(2.0f)) {
                        this.waitHome = 0;
                        this.attacker.setHeavyAttack(true);
                        this.attacker.func_70683_ar().func_75660_a();
                        this.attacker.field_70159_w += direction.field_72450_a * (double)0.1f;
                        this.attacker.field_70179_y += direction.field_72449_c * (double)0.1f;
                    }
                } else if (this.attacker.isHeavyAttacking()) {
                    this.attacker.field_70181_x += direction.field_72448_b * (double)0.2f;
                    this.attacker.field_70159_w += direction.field_72450_a * (double)0.12f;
                    this.attacker.field_70179_y += direction.field_72449_c * (double)0.12f;
                }
            }
        }

        public boolean func_75250_a() {
            if (!this.attacker.isResting()) {
                if (++this.ticksSinceLastAttack > this.interval && this.attacker.func_70638_az() != null) {
                    return true;
                }
            } else {
                this.func_75251_c();
            }
            return false;
        }

        public boolean func_75253_b() {
            boolean flag;
            boolean bl = flag = this.attacker.isHeavyAttacking() && this.attacker.func_70032_d((Entity)this.target) < (float)this.range;
            if (flag) {
                this.attacker.func_70652_k((Entity)this.target);
            }
            return !flag;
        }

        public void func_75249_e() {
            this.waitHome = 0;
            this.target = this.attacker.func_70638_az();
        }
    }

    class AIDoNothing
    extends EntityAIBase {
        int ticksSinceLastAttack;
        int interval;
        EntityKing attacker;
        float initialHealth;

        public AIDoNothing(EntityKing entity, int interval) {
            this.interval = interval;
            this.attacker = entity;
            this.func_75248_a(7);
        }

        public void func_75251_c() {
            this.attacker.setWaitingSacrifice(false);
            this.ticksSinceLastAttack = 0;
        }

        public boolean func_75250_a() {
            if (!this.attacker.isResting()) {
                if (this.attacker.isWaitingSacrifice()) {
                    return true;
                }
                if (++this.ticksSinceLastAttack > this.interval && this.attacker.func_70638_az() != null) {
                    return true;
                }
            } else {
                this.func_75251_c();
            }
            return false;
        }

        public void func_75246_d() {
            if (this.attacker.func_70638_az() != null) {
                this.attacker.func_70671_ap().func_75651_a((Entity)this.attacker.func_70638_az(), 180.0f, 180.0f);
            }
        }

        public boolean func_75253_b() {
            if (this.attacker.goHome(2.0f)) {
                this.attacker.func_70606_j(this.attacker.func_110143_aJ() - 1.0f);
                for (BlockPos pos : this.attacker.SACRIFICE_PLACES) {
                    if (Blocks.field_150340_R != this.attacker.field_70170_p.func_180495_p(pos).func_177230_c()) continue;
                    this.attacker.setWaitingSacrifice(false);
                    this.attacker.field_70170_p.func_175655_b(pos, false);
                }
            }
            if (this.attacker.isWaitingSacrifice()) {
                if (this.attacker.func_110143_aJ() < 2.0f) {
                    this.attacker.func_70106_y();
                    BlockPos pos = this.attacker.func_180425_c();
                    this.attacker.field_70170_p.func_72876_a((Entity)this.attacker, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0f, true);
                }
            } else {
                this.attacker.func_70606_j(this.initialHealth);
            }
            return this.attacker.isWaitingSacrifice();
        }

        public void func_75249_e() {
            this.attacker.setWaitingSacrifice(true);
            this.initialHealth = this.attacker.func_110143_aJ();
        }
    }

    static class AIReturnHome
    extends EntityAIBase {
        private boolean force;
        private final EntityKing slime;

        public void forceUpdate() {
            this.force = true;
        }

        public AIReturnHome(EntityKing slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return !this.slime.func_110173_bK() && !this.slime.func_180425_c().equals((Object)this.slime.func_180486_cf()) || this.force;
        }

        public void func_75249_e() {
            this.force = false;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            boolean flag;
            boolean bl = flag = !this.slime.goHome(1.5f);
            if (!flag) {
                this.slime.setRest(true);
            }
            return flag;
        }

        public void func_75246_d() {
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }
}

