/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity.boss;

import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import com.dainxt.dungeonsmod.world.gen.WorldGenCustomStructures;
import com.dainxt.dungeonsmod.world.storage.WorldCustomData;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityIronSlime
extends EntityMob {
    private static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(EntityIronSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> OUTER_SHELL_INTEGRITY = EntityDataManager.func_187226_a(EntityIronSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LAST_MINED_TICK = EntityDataManager.func_187226_a(EntityIronSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    public final float homeRange = 7.0f;
    private final float maxPhase = 5.0f;
    private final int MaxTimeBreak = 28;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public EntityIronSlime(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 3.0f);
        this.field_70765_h = new SlimeMoveHelper(this);
        this.field_70728_aV = 1500;
        this.func_110163_bv();
    }

    public boolean func_70072_I() {
        this.field_70171_ac = this.field_70170_p.func_72875_a(this.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151586_h);
        return this.field_70171_ac;
    }

    public void setLastMinedTick(int phase) {
        this.func_184212_Q().func_187227_b(LAST_MINED_TICK, (Object)phase);
    }

    public int getLastMinedTick() {
        return (Integer)this.func_184212_Q().func_187225_a(LAST_MINED_TICK);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.IRONSLIME;
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_77973_b() instanceof ItemPickaxe) {
            stack.func_77966_a(Enchantments.field_185307_s, 20);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LAST_MINED_TICK, (Object)0);
        this.field_70180_af.func_187214_a(PHASE, (Object)5);
        this.field_70180_af.func_187214_a(OUTER_SHELL_INTEGRITY, (Object)28);
    }

    public void setPhase(int phase) {
        this.func_184212_Q().func_187227_b(PHASE, (Object)phase);
    }

    public int getPhase() {
        return (Integer)this.func_184212_Q().func_187225_a(PHASE);
    }

    public void setShellIntegrity(int integrity) {
        this.func_184212_Q().func_187227_b(OUTER_SHELL_INTEGRITY, (Object)integrity);
    }

    public int getShellIntegrity() {
        return (Integer)this.func_184212_Q().func_187225_a(OUTER_SHELL_INTEGRITY);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIReturnHome(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, null));
    }

    public void func_70020_e(NBTTagCompound compound) {
        BlockPos homePos = BlockPos.func_177969_a((long)compound.func_74763_f("HomePosition"));
        if (!homePos.equals((Object)BlockPos.field_177992_a)) {
            this.func_175449_a(homePos, 7);
        }
        super.func_70020_e(compound);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        if (this.func_110175_bO()) {
            compound.func_74772_a("HomePosition", this.func_180486_cf().func_177986_g());
        }
        return super.func_189511_e(compound);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (this.getPhase() >= 2 && player.func_184614_ca().func_77973_b() instanceof ItemPickaxe) {
                if (!this.field_70170_p.field_72995_K && 0.0f == player.func_184811_cZ().func_185143_a(player.func_184614_ca().func_77973_b(), 1.0f)) {
                    player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), 10);
                    this.setLastMinedTick(this.field_70173_aa);
                    int shell = this.getShellIntegrity();
                    int reduce = this.func_70027_ad() ? 2 : 1;
                    this.setShellIntegrity(shell - reduce);
                    return true;
                }
                if (player.func_184811_cZ().func_185143_a(player.func_184614_ca().func_77973_b(), 1.0f) != 0.0f) {
                    this.func_184185_a(SoundEvents.field_187880_fp, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        if (source.func_76357_e()) {
            return super.func_70097_a(source, amount);
        }
        if (this.getPhase() >= 2) {
            if (!this.field_70170_p.field_72995_K && !this.func_70027_ad()) {
                this.func_184185_a(SoundEvents.field_187880_fp, 0.1f, 0.1f);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        this.func_70652_k((Entity)entityIn);
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        this.func_70652_k(entityIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            if (entityIn instanceof EntityLivingBase) {
                for (ItemStack itemstack : entityIn.func_184209_aF()) {
                    if (itemstack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemstack.func_77973_b()).func_82812_d().equals((Object)ItemArmor.ArmorMaterial.IRON)) {
                        itemstack.func_77972_a(5, (EntityLivingBase)entityIn);
                    }
                    if (!(itemstack.func_77973_b() instanceof ItemPickaxe)) continue;
                    if (((ItemPickaxe)itemstack.func_77973_b()).func_77861_e().equals(Item.ToolMaterial.IRON.toString())) {
                        itemstack.func_77972_a(75, (EntityLivingBase)entityIn);
                        continue;
                    }
                    itemstack.func_77972_a(5, (EntityLivingBase)entityIn);
                }
                if (this.func_70027_ad()) {
                    entityIn.func_70015_d(2);
                }
            }
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 10.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 2));
        }
        return flag;
    }

    public boolean func_85031_j(Entity entityIn) {
        return super.func_85031_j(entityIn);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        if (!this.func_110175_bO()) {
            this.func_175449_a(this.func_180425_c(), 7);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a((float)this.getPhase() * 0.5f + 0.5f, (float)this.getPhase() * 0.5f + 0.5f);
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa - this.getLastMinedTick() > 20) {
            this.setShellIntegrity(28);
        }
        if (this.getShellIntegrity() <= 0) {
            int actualPhase = this.getPhase();
            this.setPhase(--actualPhase);
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v);
            if (actualPhase == 1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
            }
            this.setShellIntegrity(28);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean clientPlayerMining() {
        boolean mining = Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
        boolean seeAttackTarget = Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY;
        return mining && seeAttackTarget;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public int getJumpDelay() {
        return 40;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float func_175134_bD() {
        return this.func_180799_ab() ? 2.0f : 0.42f;
    }

    private void faceBlockPos(BlockPos pos) {
        float f1;
        double d0 = (double)pos.func_177958_n() - this.field_70165_t;
        double d2 = (double)pos.func_177952_p() - this.field_70161_v;
        double d1 = (double)pos.func_177956_o() - this.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70177_z = f;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187605_cG;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187689_f;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
        if (this.bossInfo.func_186757_c().isEmpty()) {
            this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
            ((Object)((Object)this)).getClass();
            this.setPhase(5);
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        float bonusDamage = 0.0f;
        if ((double)this.getPhase() <= 1.0) {
            bonusDamage = 11.0f;
            this.bossInfo.func_186735_a(((float)this.getPhase() - (1.0f - this.func_110143_aJ() / 28.0f)) / this.maxPhase);
        } else {
            this.bossInfo.func_186735_a(((float)this.getPhase() - (1.0f - (float)this.getShellIntegrity() / 28.0f)) / this.maxPhase);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)((this.maxPhase + 1.0f - (float)this.getPhase()) * 0.08f + 0.5f));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((this.maxPhase + 1.0f - (float)this.getPhase()) * 2.5f + 5.5f + bonusDamage));
        float distance = Float.MAX_VALUE;
        for (EntityPlayer player : this.bossInfo.func_186757_c()) {
            distance = Math.min(player.func_70032_d((Entity)this), distance);
            if (!(player.func_70032_d((Entity)this) < 15.0f)) continue;
            player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100, 2));
        }
        if (distance > 7.0f) {
            this.func_70691_i(1.0f);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        WorldCustomData data = WorldCustomData.get(this.field_70170_p);
        data.dungeonData.resetData(WorldGenCustomStructures.THE_IRON_MINES);
    }

    static class AIReturnHome
    extends EntityAIBase {
        private final EntityIronSlime slime;
        private int growTieredTimer;

        public AIReturnHome(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return !this.slime.func_110173_bK() && !this.slime.func_180425_c().equals((Object)this.slime.func_180486_cf());
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            boolean flag = false;
            flag = new AxisAlignedBB(this.slime.func_180486_cf()).func_72326_a(this.slime.func_174813_aQ());
            return !flag;
        }

        public void func_75246_d() {
            this.slime.faceBlockPos(this.slime.func_180486_cf());
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private final EntityIronSlime slime;
        private int growTieredTimer;

        public AISlimeAttack(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private final EntityIronSlime slime;

        public AISlimeFloat(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 2.0f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(3.0);
        }
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityIronSlime slime;
        private boolean isAggressive;

        public SlimeMoveHelper(EntityIronSlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay == this.slime.getJumpDelay() || this.jumpDelay == this.slime.getJumpDelay() / 3) {
                        this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    }
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.makesSoundOnJump()) {
                            this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private final EntityIronSlime slime;

        public AISlimeHop(EntityIronSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }
}

