/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.init.EntityInit;
import com.dainxt.dungeonsmod.util.handlers.ConfigHandler;
import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySlimond
extends EntityMob {
    public EntitySlimond(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70765_h = new SlimondMoveHelper(this);
        this.func_70105_a(0.9f, 0.9f);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public boolean func_70601_bi() {
        return EntityInit.rareSpawn(this.func_70681_au(), ConfigHandler.spawnRates.Slimond, super.func_70601_bi());
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.SLIMOND;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        this.func_70652_k((Entity)entityIn);
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
        this.func_70652_k(entityIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), f);
        return flag;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimondFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimondAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimondFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimondHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.45);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
    }

    public int getJumpDelay() {
        return 20;
    }

    public boolean makesSoundOnJump() {
        return true;
    }

    public boolean canDamagePlayer() {
        return true;
    }

    protected float func_175134_bD() {
        return 0.42f;
    }

    private void faceBlockPos(BlockPos pos) {
        float f1;
        double d0 = (double)pos.func_177958_n() - this.field_70165_t;
        double d2 = (double)pos.func_177952_p() - this.field_70161_v;
        double d1 = (double)pos.func_177956_o() - this.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        this.field_70177_z = f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187878_fo;
    }

    public SoundEvent getJumpSound() {
        return SoundEvents.field_187882_fq;
    }

    static class AISlimondAttack
    extends EntityAIBase {
        private final EntitySlimond Slimond;
        private int growTieredTimer;

        public AISlimondAttack(EntitySlimond SlimondIn) {
            this.Slimond = SlimondIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.Slimond.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
        }

        public void func_75249_e() {
            this.growTieredTimer = 300;
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.Slimond.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.growTieredTimer > 0;
        }

        public void func_75246_d() {
            this.Slimond.func_70625_a((Entity)this.Slimond.func_70638_az(), 10.0f, 10.0f);
            ((SlimondMoveHelper)this.Slimond.func_70605_aq()).setDirection(this.Slimond.field_70177_z, this.Slimond.canDamagePlayer());
        }
    }

    static class AISlimondFloat
    extends EntityAIBase {
        private final EntitySlimond Slimond;

        public AISlimondFloat(EntitySlimond SlimondIn) {
            this.Slimond = SlimondIn;
            this.func_75248_a(5);
            ((PathNavigateGround)SlimondIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.Slimond.func_70090_H() || this.Slimond.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.Slimond.func_70681_au().nextFloat() < 0.8f) {
                this.Slimond.func_70683_ar().func_75660_a();
            }
            ((SlimondMoveHelper)this.Slimond.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class SlimondMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntitySlimond Slimond;
        private boolean isAggressive;

        public SlimondMoveHelper(EntitySlimond SlimondIn) {
            super((EntityLiving)SlimondIn);
            this.Slimond = SlimondIn;
            this.yRot = 180.0f * SlimondIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.Slimond.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.Slimond.func_70683_ar().func_75660_a();
                        if (this.Slimond.makesSoundOnJump()) {
                            this.Slimond.func_184185_a(this.Slimond.getJumpSound(), this.Slimond.func_70599_aP(), ((this.Slimond.func_70681_au().nextFloat() - this.Slimond.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.Slimond.field_70702_br = 0.0f;
                        this.Slimond.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AISlimondHop
    extends EntityAIBase {
        private final EntitySlimond Slimond;

        public AISlimondHop(EntitySlimond SlimondIn) {
            this.Slimond = SlimondIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimondMoveHelper)this.Slimond.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISlimondFaceRandom
    extends EntityAIBase {
        private final EntitySlimond Slimond;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimondFaceRandom(EntitySlimond SlimondIn) {
            this.Slimond = SlimondIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.Slimond.func_70638_az() == null && (this.Slimond.field_70122_E || this.Slimond.func_70090_H() || this.Slimond.func_180799_ab() || this.Slimond.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.Slimond.func_70681_au().nextInt(60);
                this.chosenDegrees = this.Slimond.func_70681_au().nextInt(360);
            }
            ((SlimondMoveHelper)this.Slimond.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }
}

