/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.dungeonsmod.entity;

import com.dainxt.dungeonsmod.util.handlers.LootTableHandler;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityPiranha
extends EntityMob {
    private boolean moving = false;
    protected EntityAIWander wander;

    public EntityPiranha(World worldIn) {
        super(worldIn);
        this.field_70765_h = new PiranhaMoveHelper(this);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70728_aV = 2;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.PIRANHA;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            Vec3d vec = this.func_70638_az().func_174791_d();
            this.func_70107_b(vec.field_72450_a, vec.field_72448_b + (double)this.func_70638_az().func_70047_e() * 0.75, vec.field_72449_c);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.wander = new EntityAIWander((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIPiranhaAttack(this, 1.0, false));
        this.wander.func_75248_a(4);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        entityaimovetowardsrestriction.func_75248_a(3);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new PiranhaTargetSelector(this)));
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (!this.isMoving() && this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    private void setMoving(boolean Moving) {
        this.moving = Moving;
    }

    private boolean isMoving() {
        return this.moving;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.08;
        }
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public static class PiranhaTargetSelector
    implements Predicate<EntityLivingBase> {
        private final EntityPiranha parentEntity;

        public PiranhaTargetSelector(EntityPiranha guardian) {
            this.parentEntity = guardian;
        }

        public boolean apply(@Nullable EntityLivingBase p_apply_1_) {
            return p_apply_1_ instanceof EntityPlayer && p_apply_1_.func_70068_e((Entity)this.parentEntity) > 9.0;
        }
    }

    static class AIPiranhaAttack
    extends EntityAIAttackMelee {
        EntityPiranha piranha;

        public AIPiranhaAttack(EntityPiranha creature, double speedIn, boolean useLongMemory) {
            super((EntityCreature)creature, speedIn, useLongMemory);
            this.piranha = creature;
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.piranha.func_70638_az();
            if (!entitylivingbase.func_70090_H()) {
                this.piranha.field_70181_x += 0.07;
            }
            super.func_75246_d();
        }
    }

    static class PiranhaMoveHelper
    extends EntityMoveHelper {
        private final EntityPiranha entityPiranha;

        public PiranhaMoveHelper(EntityPiranha piranha) {
            super((EntityLiving)piranha);
            this.entityPiranha = piranha;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.entityPiranha.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.entityPiranha.field_70165_t;
                double d1 = this.field_75647_c - this.entityPiranha.field_70163_u;
                double d2 = this.field_75644_d - this.entityPiranha.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.entityPiranha.field_70761_aq = this.entityPiranha.field_70177_z = this.func_75639_a(this.entityPiranha.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.entityPiranha.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.entityPiranha.func_70659_e(this.entityPiranha.func_70689_ay() + (f1 - this.entityPiranha.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.entityPiranha.field_70173_aa + this.entityPiranha.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.entityPiranha.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.entityPiranha.field_70177_z * ((float)Math.PI / 180));
                this.entityPiranha.field_70159_w += d4 * d5;
                this.entityPiranha.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.entityPiranha.field_70173_aa + this.entityPiranha.func_145782_y()) * 0.75) * 0.05;
                this.entityPiranha.field_70181_x += d4 * (d6 + d5) * 0.25;
                this.entityPiranha.field_70181_x += (double)this.entityPiranha.func_70689_ay() * d1 * 0.1;
                EntityLookHelper entitylookhelper = this.entityPiranha.func_70671_ap();
                double d7 = this.entityPiranha.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.entityPiranha.func_70047_e() + this.entityPiranha.field_70163_u + d1 / d3;
                double d9 = this.entityPiranha.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.entityPiranha.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.entityPiranha.setMoving(true);
            } else {
                this.entityPiranha.func_70659_e(0.0f);
                this.entityPiranha.setMoving(false);
            }
        }
    }
}

