/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.items.DTItemGeneric;

public class DTSoulgem
extends DTItemGeneric {
    private static final String SOULBOUND = "EntityTag";
    private static final String SOUL_ID = "id";
    private static final String SOULPOWER = "EntityLevel";
    private static final String SOUL_LVL = "lvl";

    public DTSoulgem(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return DTSoulgem.getSoulIdFrom(stack) != null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77973_b() == DTItems.SOULGEM) {
            if (DTSoulgem.getSoulIdFrom(stack) != null) {
                String boundName = EntityList.func_191302_a((ResourceLocation)DTSoulgem.getSoulIdFrom(stack));
                int soulLevel = DTSoulgem.getSoulLevelFrom(stack);
                tooltip.add("Bound Soul: " + boundName);
                if (soulLevel >= 50) {
                    tooltip.add("Soul Level: MAX");
                } else if (soulLevel > 0) {
                    tooltip.add("Soul Level: " + soulLevel + "/50");
                }
            } else {
                tooltip.add("Bound Soul: None");
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return DTSoulgem.prepareEntity(stack, player, target);
    }

    public static boolean prepareEntity(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        boolean flag = player.func_184812_l_();
        if (!target.func_184222_aU() && !flag) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Target is too powerful to bind."));
            return false;
        }
        if (target.func_110143_aJ() > target.func_110138_aP() / 3.0f && !flag) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Target must be weakened first."));
            return false;
        }
        if (DTSoulgem.getSoulIdFrom(stack) != null && DTSoulgem.getSoulLevelFrom(stack) >= 50) {
            return false;
        }
        if (target instanceof EntityPlayer) {
            return false;
        }
        if (player.func_130014_f_().field_72995_K) {
            return true;
        }
        if (target.func_184218_aH()) {
            target.func_184210_p();
        }
        if (target.func_184207_aI()) {
            for (Entity entity : target.func_184188_bt()) {
                entity.func_184210_p();
            }
        }
        if (target.func_184218_aH() || target.func_184207_aI()) {
            return false;
        }
        ItemStack boundGem = new ItemStack(DTItems.SOULGEM);
        boolean success = false;
        int lvl = 1;
        int i = 0;
        if (flag) {
            lvl = 50;
        }
        if (!target.field_70128_L) {
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74764_b(SOULBOUND) && !DTSoulgem.getSoulIdFrom(stack).equals((Object)EntityList.func_191301_a((Entity)target))) {
                    return false;
                }
                i = stack.func_77978_p().func_74775_l(SOULPOWER).func_74762_e(SOUL_LVL);
            }
            success = DTSoulgem.bindSoul(boundGem, player, target, lvl + i);
        }
        if (success) {
            player.field_71071_by.func_184437_d(stack);
            player.func_191521_c(boundGem);
            target.func_70106_y();
        }
        return success;
    }

    public static boolean bindSoul(ItemStack stack, EntityPlayer player, EntityLivingBase soul, int lvl) {
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompoundID = new NBTTagCompound();
        nbttagcompoundID.func_74778_a(SOUL_ID, EntityList.func_191301_a((Entity)soul).toString());
        nbttagcompound.func_74782_a(SOULBOUND, (NBTBase)nbttagcompoundID);
        stack.func_77982_d(nbttagcompound);
        NBTTagCompound nbttagcompoundLVL = new NBTTagCompound();
        nbttagcompoundLVL.func_74768_a(SOUL_LVL, lvl);
        nbttagcompound.func_74782_a(SOULPOWER, (NBTBase)nbttagcompoundLVL);
        stack.func_77982_d(nbttagcompound);
        return true;
    }

    @Nullable
    public static ResourceLocation getSoulIdFrom(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        if (!nbttagcompound.func_150297_b(SOULBOUND, 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(SOULBOUND);
        if (!nbttagcompound1.func_150297_b(SOUL_ID, 8)) {
            return null;
        }
        String s = nbttagcompound1.func_74779_i(SOUL_ID);
        ResourceLocation resourcelocation = new ResourceLocation(s);
        if (!s.contains(":")) {
            nbttagcompound1.func_74778_a(SOUL_ID, resourcelocation.toString());
        }
        return resourcelocation;
    }

    @Nullable
    public static int getSoulLevelFrom(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            return 0;
        }
        if (!nbttagcompound.func_150297_b(SOULPOWER, 10)) {
            return 0;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l(SOULPOWER);
        if (nbttagcompound1 == null) {
            return 0;
        }
        int i = nbttagcompound1.func_74762_e(SOUL_LVL);
        return i;
    }
}

