/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.entities.projectiles.DTEntityBullet;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.handlers.DTItems;

public class DTPotshot
extends ItemBow {
    public DTPotshot(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_WEAPONS_TAB);
        this.func_77625_d(1);
        this.func_77656_e(768);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.func_184607_cu().func_77973_b() != DTItems.POTSHOT ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public int func_77619_b() {
        return 2;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean flag1 = !this.hasAmmo(player).func_190926_b();
        boolean flag2 = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)player.func_184586_b(hand)) > 0;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)player.func_184586_b(hand), (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag1);
        if (ret != null) {
            return ret;
        }
        if (!flag2 && !flag1) {
            return !flag1 ? new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand)) : new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private ItemStack hasAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isAmmo(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == DTItems.POTSHOTAMMO;
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 5.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack ammoType = this.hasAmmo(player);
            boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            boolean cluster = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.CLUSTER, (ItemStack)stack) > 0;
            float boom = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.BOOM, (ItemStack)stack);
            boolean slime = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.SLIME, (ItemStack)stack) > 0;
            boolean fire = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0;
            int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            int kick = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (!ammoType.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoType.func_190926_b() || flag) {
                float f;
                if (ammoType.func_190926_b()) {
                    ammoType = new ItemStack(DTItems.POTSHOTAMMO);
                }
                if ((double)(f = DTPotshot.getProjectileVelocity(i)) >= 0.1) {
                    if (!world.field_72995_K) {
                        DTEntityBullet bullet = new DTEntityBullet(world, (EntityLivingBase)player);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        float yaw = player.field_70177_z;
                        float pitch = player.field_70125_A;
                        float f1 = -0.1f;
                        double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                        double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f1;
                        bullet.cluster = cluster;
                        bullet.field_190534_ay = fire;
                        bullet.slime = slime;
                        bullet.damage = power;
                        bullet.knockbackStrength = kick;
                        bullet.explosionRadius = boom;
                        bullet.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
                        world.func_72838_d((Entity)bullet);
                        player.field_70159_w = motionX;
                        player.field_70179_y = motionZ;
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
                    }
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
                    if (!flag) {
                        ammoType.func_190918_g(1);
                        if (ammoType.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoType);
                        }
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        int cd = 15;
                        if (cluster) {
                            cd += 5;
                        }
                        if (fire || slime) {
                            cd += 5;
                        }
                        if (power > 0 || kick > 0) {
                            cd += 5;
                        }
                        if (boom > 0.0f) {
                            cd += 10;
                        }
                        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), cd);
                    }
                }
            }
        }
    }
}

