/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pegbeard.dungeontactics.blocks.DTBarrel;
import pegbeard.dungeontactics.blocks.DTBlockGeneric;
import pegbeard.dungeontactics.blocks.DTBlockGenericOdd;
import pegbeard.dungeontactics.blocks.DTBrazier;
import pegbeard.dungeontactics.blocks.DTBushCherryBomb;
import pegbeard.dungeontactics.blocks.DTBushGlowcurrent;
import pegbeard.dungeontactics.blocks.DTBushIncindiberry;
import pegbeard.dungeontactics.blocks.DTCaltrops;
import pegbeard.dungeontactics.blocks.DTCauldron;
import pegbeard.dungeontactics.blocks.DTChair;
import pegbeard.dungeontactics.blocks.DTClimbingRope;
import pegbeard.dungeontactics.blocks.DTCushion;
import pegbeard.dungeontactics.blocks.DTDungeonGlass;
import pegbeard.dungeontactics.blocks.DTFanBlock;
import pegbeard.dungeontactics.blocks.DTFence;
import pegbeard.dungeontactics.blocks.DTFlamerBlock;
import pegbeard.dungeontactics.blocks.DTFlower;
import pegbeard.dungeontactics.blocks.DTFlowerItem;
import pegbeard.dungeontactics.blocks.DTGrinderBlock;
import pegbeard.dungeontactics.blocks.DTGuardianAlter;
import pegbeard.dungeontactics.blocks.DTLantern;
import pegbeard.dungeontactics.blocks.DTMushroom;
import pegbeard.dungeontactics.blocks.DTOreGeneric;
import pegbeard.dungeontactics.blocks.DTPowderkeg;
import pegbeard.dungeontactics.blocks.DTRadio;
import pegbeard.dungeontactics.blocks.DTTrap;
import pegbeard.dungeontactics.blocks.DTWeb;
import pegbeard.dungeontactics.blocks.tileentities.DTBarrelTile;
import pegbeard.dungeontactics.blocks.tileentities.DTBrazierTile;
import pegbeard.dungeontactics.blocks.tileentities.DTFanTile;
import pegbeard.dungeontactics.blocks.tileentities.DTFlamerTile;
import pegbeard.dungeontactics.blocks.tileentities.DTLanternTile;

@GameRegistry.ObjectHolder(value="dungeontactics")
public class DTBlocks {
    public static Block ORE_SILVER = new DTOreGeneric("silver_ore", 3.0f, 5.0f, "pickaxe", 2);
    public static Block ORE_MITHRIL = new DTOreGeneric("mithril_ore", 3.0f, 5.0f, "pickaxe", 3);
    public static Block NETHER_GOLD = new DTOreGeneric("nethergold_ore", 3.0f, 5.0f, "pickaxe", 2);
    public static Block STONE_QUARTZ = new DTOreGeneric("stonequartz_ore", 3.0f, 5.0f, "pickaxe", 2);
    public static Block END_DIAMOND = new DTOreGeneric("enddiamond_ore", 3.0f, 5.0f, "pickaxe", 2);
    public static Block END_LAPIS = new DTOreGeneric("endlapis_ore", 3.0f, 5.0f, "pickaxe", 2);
    public static Block BLOCK_SILVER = new DTBlockGeneric("silver_block", Material.field_151573_f, 3.0f, 10.0f, "pickaxe", 2);
    public static Block BLOCK_STEEL = new DTBlockGeneric("steel_block", Material.field_151573_f, 5.0f, 10.0f, "pickaxe", 1);
    public static Block BLOCK_MITHRIL = new DTBlockGeneric("mithril_block", Material.field_151573_f, 5.0f, 10.0f, "pickaxe", 2);
    public static Block OBSIDIAN_BRICK = new DTBlockGeneric("obsidianbrick", Material.field_151576_e, 9.0f, 6000.0f, "pickaxe", 1);
    public static Block DUNGEON_GLASS = new DTDungeonGlass("dungeon_glass", Material.field_151592_s, false, 0.3f, 1.5f);
    public static Block WHITECUSHION = new DTCushion("cushion_white", Material.field_151580_n, 3.0f, 5.0f);
    public static Block LIGHTGREYCUSHION = new DTCushion("cushion_light_grey", Material.field_151580_n, 3.0f, 5.0f);
    public static Block GREYCUSHION = new DTCushion("cushion_grey", Material.field_151580_n, 3.0f, 5.0f);
    public static Block BLACKCUSHION = new DTCushion("cushion_black", Material.field_151580_n, 3.0f, 5.0f);
    public static Block PINKCUSHION = new DTCushion("cushion_pink", Material.field_151580_n, 3.0f, 5.0f);
    public static Block REDCUSHION = new DTCushion("cushion_red", Material.field_151580_n, 3.0f, 5.0f);
    public static Block ORANGECUSHION = new DTCushion("cushion_orange", Material.field_151580_n, 3.0f, 5.0f);
    public static Block YELLOWCUSHION = new DTCushion("cushion_yellow", Material.field_151580_n, 3.0f, 5.0f);
    public static Block LIMECUSHION = new DTCushion("cushion_lime", Material.field_151580_n, 3.0f, 5.0f);
    public static Block GREENCUSHION = new DTCushion("cushion_green", Material.field_151580_n, 3.0f, 5.0f);
    public static Block LIGHTBLUECUSHION = new DTCushion("cushion_light_blue", Material.field_151580_n, 3.0f, 5.0f);
    public static Block BLUECUSHION = new DTCushion("cushion_blue", Material.field_151580_n, 3.0f, 5.0f);
    public static Block CYANCUSHION = new DTCushion("cushion_cyan", Material.field_151580_n, 3.0f, 5.0f);
    public static Block MAGENTACUSHION = new DTCushion("cushion_magenta", Material.field_151580_n, 3.0f, 5.0f);
    public static Block PURPLECUSHION = new DTCushion("cushion_purple", Material.field_151580_n, 3.0f, 5.0f);
    public static Block BROWNCUSHION = new DTCushion("cushion_brown", Material.field_151580_n, 3.0f, 5.0f);
    public static Block WOODCHAIR = new DTChair("wooden_chair", Material.field_151575_d, 3.0f, 5.0f);
    public static Block WOODTABLE = new DTBlockGenericOdd("wooden_table", Material.field_151575_d, 3.0f, 5.0f);
    public static Block RADIO = new DTRadio("radio", 3.0f, 5.0f);
    public static Block BRAZIER = new DTBrazier("brazier", Material.field_151573_f, 0.5f, 2.5f);
    public static Block LANTERN_IRON = new DTLantern("lantern_iron", Material.field_151573_f, 0.5f, 2.5f);
    public static Block LANTERN_MAGIC = new DTLantern("lantern_magic", Material.field_151573_f, 0.5f, 2.5f);
    public static Block ALCHEMYCAULDRON = new DTCauldron("alchemical_cauldron", Material.field_151573_f, 2.0f, 2.5f);
    public static Block BARREL = new DTBarrel("barrel", Material.field_151575_d, 0.5f, 2.5f);
    public static Block POWDERKEG = new DTPowderkeg("powderkeg", Material.field_151575_d, 0.5f, 2.5f);
    public static Block WITHER_WEB = new DTWeb("wither_web", Material.field_151569_G, 4.0f, 7.0f);
    public static Block CLIMBINGROPE = new DTClimbingRope("climbing_rope", Material.field_151580_n, 3.0f, 5.0f);
    public static Block POWERED_FENCE = new DTFence("powered_bars", Material.field_151573_f, 5.0f, 30.0f);
    public static Block FAN_BLOCK = new DTFanBlock("fan_block", Material.field_151576_e, 0.5f, 2.5f);
    public static Block FLAMER_BLOCK = new DTFlamerBlock("flamer_block", Material.field_151576_e, 0.5f, 2.5f);
    public static Block GRINDER_BLOCK = new DTGrinderBlock("grinder_block", Material.field_151576_e, 0.5f, 2.5f);
    public static Block CALTROPS = new DTCaltrops("caltrops", Material.field_151575_d, 0.5f, 2.5f);
    public static Block CALTROPSPOISON = new DTCaltrops("caltrops_poison", Material.field_151575_d, 0.5f, 2.5f);
    public static Block TRAP_CLAMP = new DTTrap("trap_clamp", Material.field_151576_e, 0.5f, 2.5f, MapColor.field_151669_i);
    public static Block TRAP_BOOM = new DTTrap("trap_boom", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_PISTON = new DTTrap("trap_piston", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_FIRE = new DTTrap("trap_fire", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_FOUL = new DTTrap("trap_foul", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_AILMENT = new DTTrap("trap_ailment", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_PORT = new DTTrap("trap_port", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_AMBUSH = new DTTrap("trap_ambush", Material.field_151576_e, 0.5f, 2.5f);
    public static Block TRAP_SPECTRAL = new DTTrap("trap_spectral", Material.field_151576_e, 0.5f, 2.5f);
    public static Block MUSHROOM_BLAST = new DTMushroom("mushroom_blast");
    public static Block MUSHROOM_COAL = new DTMushroom("mushroom_coal");
    public static Block MUSHROOM_IRON = new DTMushroom("mushroom_iron");
    public static Block MUSHROOM_SILVER = new DTMushroom("mushroom_silver");
    public static Block MUSHROOM_GOLD = new DTMushroom("mushroom_gold");
    public static Block MUSHROOM_STEEL = new DTMushroom("mushroom_steel");
    public static Block MUSHROOM_MITHRIL = new DTMushroom("mushroom_mithril");
    public static Block FLOWER_SANGUINE = new DTFlower("flower_sanguine");
    public static Block FLOWER_XP = new DTFlower("flower_xp");
    public static Block FLOWER_BRAMBLE = new DTFlower("flower_bramble");
    public static Block FLOWER_BARK = new DTFlower("flower_bark");
    public static Block FLOWER_CINDER = new DTFlower("flower_cinder");
    public static Block FLOWER_TANGLE = new DTFlower("flower_tangle");
    public static Block FLOWER_AILMENT = new DTFlower("flower_ailment");
    public static Block FLOWER_FADE = new DTFlower("flower_fade");
    public static Block FLOWER_FEATHER = new DTFlower("flower_feather");
    public static Block CHERRYBOMB_BUSH = new DTBushCherryBomb("bush_cherrybomb");
    public static Block INCINDIBERRY_BUSH = new DTBushIncindiberry("bush_incindiberry");
    public static Block GLOWCURRENT_BUSH = new DTBushGlowcurrent("bush_glowcurrent");
    public static Block GUARDIAN_ALTER = new DTGuardianAlter("guardian_alter", Material.field_151576_e, 60.0f, 6000001.0f, "pickaxe", 3);

    private static void registerTileEntities() {
        DTBlocks.registerTileEntity(DTRadio.DTRadioTile.class, RADIO.getRegistryName().toString());
        DTBlocks.registerTileEntity(DTBrazierTile.class, BRAZIER.getRegistryName().toString());
        DTBlocks.registerTileEntity(DTLanternTile.class, LANTERN_MAGIC.getRegistryName().toString());
        DTBlocks.registerTileEntity(DTBarrelTile.class, BARREL.getRegistryName().toString());
        DTBlocks.registerTileEntity(DTFanTile.class, FAN_BLOCK.getRegistryName().toString());
        DTBlocks.registerTileEntity(DTFlamerTile.class, FLAMER_BLOCK.getRegistryName().toString());
    }

    private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String name) {
        ResourceLocation res = new ResourceLocation(name + ".tile");
        GameRegistry.registerTileEntity(tileEntityClass, (ResourceLocation)res);
    }

    @Mod.EventBusSubscriber(modid="dungeontactics")
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            Block[] blocks = new Block[]{ORE_SILVER, ORE_MITHRIL, NETHER_GOLD, STONE_QUARTZ, END_DIAMOND, END_LAPIS, BLOCK_SILVER, BLOCK_STEEL, BLOCK_MITHRIL, OBSIDIAN_BRICK, DUNGEON_GLASS, WHITECUSHION, LIGHTGREYCUSHION, GREYCUSHION, BLACKCUSHION, PINKCUSHION, REDCUSHION, ORANGECUSHION, YELLOWCUSHION, LIMECUSHION, GREENCUSHION, LIGHTBLUECUSHION, BLUECUSHION, CYANCUSHION, MAGENTACUSHION, PURPLECUSHION, BROWNCUSHION, WOODCHAIR, WOODTABLE, RADIO, BRAZIER, LANTERN_IRON, LANTERN_MAGIC, ALCHEMYCAULDRON, BARREL, POWDERKEG, WITHER_WEB, CLIMBINGROPE, POWERED_FENCE, FAN_BLOCK, FLAMER_BLOCK, GRINDER_BLOCK, CALTROPS, CALTROPSPOISON, TRAP_CLAMP, TRAP_BOOM, TRAP_PISTON, TRAP_FIRE, TRAP_FOUL, TRAP_AILMENT, TRAP_PORT, TRAP_AMBUSH, TRAP_SPECTRAL, MUSHROOM_BLAST, MUSHROOM_COAL, MUSHROOM_IRON, MUSHROOM_SILVER, MUSHROOM_GOLD, MUSHROOM_STEEL, MUSHROOM_MITHRIL, FLOWER_SANGUINE, FLOWER_XP, FLOWER_BRAMBLE, FLOWER_BARK, FLOWER_CINDER, FLOWER_TANGLE, FLOWER_AILMENT, FLOWER_FADE, FLOWER_FEATHER, CHERRYBOMB_BUSH, INCINDIBERRY_BUSH, GLOWCURRENT_BUSH, GUARDIAN_ALTER};
            registry.registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock(ORE_SILVER), new ItemBlock(ORE_MITHRIL), new ItemBlock(NETHER_GOLD), new ItemBlock(STONE_QUARTZ), new ItemBlock(END_DIAMOND), new ItemBlock(END_LAPIS), new ItemBlock(BLOCK_SILVER), new ItemBlock(BLOCK_STEEL), new ItemBlock(BLOCK_MITHRIL), new ItemBlock(OBSIDIAN_BRICK), new ItemBlock(DUNGEON_GLASS), new ItemBlock(WHITECUSHION), new ItemBlock(LIGHTGREYCUSHION), new ItemBlock(GREYCUSHION), new ItemBlock(BLACKCUSHION), new ItemBlock(PINKCUSHION), new ItemBlock(REDCUSHION), new ItemBlock(ORANGECUSHION), new ItemBlock(YELLOWCUSHION), new ItemBlock(LIMECUSHION), new ItemBlock(GREENCUSHION), new ItemBlock(LIGHTBLUECUSHION), new ItemBlock(BLUECUSHION), new ItemBlock(CYANCUSHION), new ItemBlock(MAGENTACUSHION), new ItemBlock(PURPLECUSHION), new ItemBlock(BROWNCUSHION), new ItemBlock(WOODCHAIR), new ItemBlock(WOODTABLE), new ItemBlock(RADIO), new ItemBlock(BRAZIER), new ItemBlock(LANTERN_IRON), new ItemBlock(LANTERN_MAGIC), new ItemBlock(ALCHEMYCAULDRON), new ItemBlock(BARREL), new ItemBlock(POWDERKEG), new ItemBlock(WITHER_WEB), new ItemBlock(CLIMBINGROPE), new ItemBlock(POWERED_FENCE), new ItemBlock(FAN_BLOCK), new ItemBlock(FLAMER_BLOCK), new ItemBlock(GRINDER_BLOCK), new ItemBlock(CALTROPS), new ItemBlock(CALTROPSPOISON), new ItemBlock(TRAP_CLAMP), new ItemBlock(TRAP_BOOM), new ItemBlock(TRAP_PISTON), new ItemBlock(TRAP_FIRE), new ItemBlock(TRAP_FOUL), new ItemBlock(TRAP_AILMENT), new ItemBlock(TRAP_PORT), new ItemBlock(TRAP_AMBUSH), new ItemBlock(TRAP_SPECTRAL), new DTFlowerItem(MUSHROOM_BLAST), new DTFlowerItem(MUSHROOM_COAL), new DTFlowerItem(MUSHROOM_IRON), new DTFlowerItem(MUSHROOM_SILVER), new DTFlowerItem(MUSHROOM_GOLD), new DTFlowerItem(MUSHROOM_STEEL), new DTFlowerItem(MUSHROOM_MITHRIL), new DTFlowerItem(FLOWER_SANGUINE), new DTFlowerItem(FLOWER_XP), new DTFlowerItem(FLOWER_BRAMBLE), new DTFlowerItem(FLOWER_BARK), new DTFlowerItem(FLOWER_CINDER), new DTFlowerItem(FLOWER_TANGLE), new DTFlowerItem(FLOWER_AILMENT), new DTFlowerItem(FLOWER_FADE), new DTFlowerItem(FLOWER_FEATHER), new ItemBlock(CHERRYBOMB_BUSH), new ItemBlock(INCINDIBERRY_BUSH), new ItemBlock(GLOWCURRENT_BUSH), new ItemBlock(GUARDIAN_ALTER)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                Block block = item.func_179223_d();
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                registry.register(item.setRegistryName(registryName));
                ITEM_BLOCKS.add(item);
            }
            DTBlocks.registerTileEntities();
        }
    }
}

