/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks.tileentities;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.reference.Reference;

public class DTBrazierTile
extends TileEntity
implements ITickable {
    private boolean isLit = false;
    private int cooldown = 0;
    private int mincooldown = 100;
    private int maxcooldown = 400;
    private int maxmobcount = 8;
    private static final String SOULBOUND = "EntityTag";
    private static final String SOUL_ID = "id";
    private ResourceLocation entityToSpawn = Reference.ENTITY_EMPTY;

    public void func_73660_a() {
        if (!this.getLit() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.cooldown <= 0) {
            this.spawnEntities(1 + this.func_145831_w().field_73012_v.nextInt(3), this.getEntName());
            this.resetTimer();
        }
    }

    public boolean canSpawn() {
        if (!this.isPlayerClose()) {
            return false;
        }
        return ForgeRegistries.ENTITIES.containsKey(this.entityToSpawn);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189515_b(new NBTTagCompound()));
    }

    @SideOnly(value=Side.CLIENT)
    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void reset(ItemStack stack, IBlockState state, BlockPos pos) {
        if (stack.func_190926_b()) {
            this.setEntName(Reference.ENTITY_EMPTY);
        } else {
            this.setEntName(DTBrazierTile.getNamedIdFrom(stack));
        }
        this.resetTimer();
        this.func_70296_d();
        this.func_145831_w().func_184138_a(pos, state, state, 3);
    }

    private void resetTimer() {
        int i = this.mincooldown + this.func_145831_w().field_73012_v.nextInt(this.maxcooldown);
        this.setCooldown(i);
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            return null;
        }
        if (!compound.func_150297_b(SOULBOUND, 10)) {
            return null;
        }
        NBTTagCompound compound1 = compound.func_74775_l(SOULBOUND);
        if (!compound1.func_150297_b(SOUL_ID, 8)) {
            return null;
        }
        String s = compound1.func_74779_i(SOUL_ID);
        ResourceLocation resourcelocation = new ResourceLocation(s);
        if (!s.contains(":")) {
            compound1.func_74778_a(SOUL_ID, resourcelocation.toString());
        }
        return resourcelocation;
    }

    private void spawnEntities(int amount, ResourceLocation entName) {
        block0: for (int i = 0; i < amount; ++i) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                double x = (double)this.func_174877_v().func_177958_n() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0;
                double y = this.func_174877_v().func_177956_o() + this.func_145831_w().field_73012_v.nextInt(3) - 1;
                double z = (double)this.func_174877_v().func_177952_p() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0;
                BlockPos spawnAt = new BlockPos(x, y, z);
                EntityLiving entityLiving = (EntityLiving)EntityList.func_188429_b((ResourceLocation)entName, (World)this.func_145831_w());
                if (entityLiving == null) {
                    return;
                }
                entityLiving.func_70012_b((double)spawnAt.func_177958_n(), (double)spawnAt.func_177956_o(), (double)spawnAt.func_177952_p(), MathHelper.func_76142_g((float)(this.func_145831_w().field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityLiving.field_98038_p = true;
                entityLiving.func_110163_bv();
                if (!this.canSpawnAtCoords(entityLiving) || entityLiving.field_70128_L || this.hasReachedSpawnCap(entityLiving)) continue;
                this.func_145831_w().func_72838_d((Entity)entityLiving);
                entityLiving.func_180482_a(this.func_145831_w().func_175649_E(spawnAt), null);
                continue block0;
            }
        }
    }

    private boolean canSpawnAtCoords(EntityLiving entityLiving) {
        return entityLiving.func_70058_J();
    }

    private boolean isPlayerClose() {
        return this.func_145831_w().func_175636_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 16.0);
    }

    private boolean hasReachedSpawnCap(EntityLiving living) {
        AxisAlignedBB box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 16), (double)(this.func_174877_v().func_177956_o() - 16), (double)(this.func_174877_v().func_177952_p() - 16), (double)(this.func_174877_v().func_177958_n() + 16), (double)(this.func_174877_v().func_177956_o() + 16), (double)(this.func_174877_v().func_177952_p() + 16));
        int mobCount = 0;
        for (EntityLiving entity : this.func_145831_w().func_72872_a(living.getClass(), box)) {
            ++mobCount;
        }
        return mobCount >= this.maxmobcount;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int newTime) {
        this.cooldown = newTime;
    }

    public int getSpawnAmount() {
        return this.maxmobcount;
    }

    public ResourceLocation getEntName() {
        return this.entityToSpawn;
    }

    public void setEntName(ResourceLocation entityName) {
        this.entityToSpawn = entityName;
    }

    public boolean getLit() {
        return this.isLit;
    }

    public void setLit(boolean b) {
        this.isLit = b;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.entityToSpawn = nbttagcompound.func_74779_i("entityToSpawn") == null ? Reference.ENTITY_EMPTY : new ResourceLocation(nbttagcompound.func_74779_i("entityToSpawn"));
        this.cooldown = nbttagcompound.func_74762_e("cooldown");
        this.isLit = nbttagcompound.func_74767_n("isLit");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("cooldown", this.getCooldown());
        nbttagcompound.func_74757_a("isLit", this.getLit());
        if (this.entityToSpawn != Reference.ENTITY_EMPTY) {
            nbttagcompound.func_74778_a("entityToSpawn", this.entityToSpawn.toString());
        }
        return nbttagcompound;
    }
}

