/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.blocks.DTBlockGeneric;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTItems;

public class DTTrap
extends DTBlockGeneric {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.03125, 0.75);
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");
    public static final PropertyBool HIDDEN = PropertyBool.func_177716_a((String)"hidden");

    public DTTrap(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HIDDEN, (Comparable)Boolean.valueOf(false)));
    }

    public DTTrap(String name, Material material, float hardness, float resistance, MapColor mapColor) {
        super(name, material, hardness, resistance, mapColor);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HIDDEN, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TRIGGERED, HIDDEN});
    }

    public boolean isTriggered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TRIGGERED);
    }

    public void setTriggeredState(World world, BlockPos pos, boolean b) {
        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(b)), 2);
        this.playClickSound(world, pos, b);
    }

    public boolean cycleTriggeredState(World world, BlockPos pos) {
        if (world.func_180501_a(pos, world.func_180495_p(pos).func_177231_a((IProperty)TRIGGERED), 2)) {
            this.playClickSound(world, pos, true);
            return true;
        }
        return false;
    }

    public boolean isHidden(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HIDDEN);
    }

    public void setHiddenState(World world, BlockPos pos, boolean b) {
        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)HIDDEN, (Comparable)Boolean.valueOf(b)), 2);
        this.playClickSound(world, pos, b);
    }

    public boolean cycleHiddenState(World world, BlockPos pos) {
        if (world.func_180501_a(pos, world.func_180495_p(pos).func_177231_a((IProperty)HIDDEN), 2)) {
            this.playClickSound(world, pos, true);
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(meta == 1)).func_177226_a((IProperty)HIDDEN, (Comparable)Boolean.valueOf((meta & 2) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        int n = i = (Boolean)state.func_177229_b((IProperty)TRIGGERED) != false ? 1 : 0;
        if (((Boolean)state.func_177229_b((IProperty)HIDDEN)).booleanValue()) {
            i |= 2;
        }
        return i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.canBePlacedOn(world, pos.func_177977_b());
    }

    private boolean canBePlacedOn(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185896_q() || world.func_180495_p(pos).func_177230_c() instanceof BlockFence;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBePlacedOn(world, pos.func_177977_b())) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    protected void updateNeighbors(World world, BlockPos pos) {
        world.func_175685_c(pos, (Block)this, false);
        world.func_175685_c(pos.func_177977_b(), (Block)this, false);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    protected void playClickSound(World world, BlockPos pos, boolean b) {
        if (b) {
            world.func_184133_a(null, pos, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            world.func_184133_a(null, pos, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public boolean isEngineer(EntityLivingBase entityLiving) {
        return !entityLiving.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && entityLiving.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == DTItems.ENGINEERS_DUNGAREES;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!this.isTriggered(state) && entity instanceof EntityLivingBase) {
            boolean engineer = false;
            if (entity instanceof EntityPlayer) {
                engineer = this.isEngineer((EntityLivingBase)entity);
            }
            if (this.isHidden(state) && !(entity instanceof EntityPlayer)) {
                return;
            }
            if (!engineer) {
                if (world.field_72995_K) {
                    this.doParticles(world, pos);
                }
                if (!world.field_72995_K) {
                    this.springTrap(world, (EntityLivingBase)entity, pos, state);
                }
            }
        }
    }

    public void springTrap(World world, EntityLivingBase entityLiving, BlockPos pos, IBlockState state) {
        AxisAlignedBB axisalignedbb;
        List list;
        this.setTriggeredState(world, pos, true);
        this.setHiddenState(world, pos, false);
        if (this == DTBlocks.TRAP_BOOM && !world.field_72995_K) {
            world.func_72885_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f), 2.5f, false, true);
        }
        if (this == DTBlocks.TRAP_PISTON) {
            double motionX = entityLiving.field_70159_w;
            double motionZ = entityLiving.field_70179_y;
            if (!world.field_72995_K) {
                entityLiving.field_70159_w = motionX;
                entityLiving.field_70179_y = motionZ;
                entityLiving.field_70181_x = 1.0;
                if (entityLiving instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entityLiving).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entityLiving)));
                }
            }
            world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f));
        }
        if (this == DTBlocks.TRAP_FIRE) {
            entityLiving.func_70015_d(6);
            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
        if (this == DTBlocks.TRAP_CLAMP) {
            entityLiving.func_70097_a(DamageSource.field_76377_j, 4.0f);
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 160, 5));
            world.func_184133_a(null, pos, SoundEvents.field_187692_g, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
        if (this == DTBlocks.TRAP_FOUL) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 1));
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, 1));
            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 0.1f);
        }
        if (this == DTBlocks.TRAP_AILMENT) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 80, 0));
            world.func_184133_a(null, pos, SoundEvents.field_187581_bW, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
        if (this == DTBlocks.TRAP_PORT) {
            if (entityLiving.func_184218_aH()) {
                entityLiving.func_184210_p();
            }
            if (entityLiving.func_184207_aI()) {
                entityLiving.func_184226_ay();
            }
            if (entityLiving instanceof EntityPlayer) {
                ((EntityPlayer)entityLiving).func_70634_a(entityLiving.field_70165_t + world.field_73012_v.nextGaussian() * 10.0, entityLiving.field_70163_u + world.field_73012_v.nextGaussian() * 10.0, entityLiving.field_70161_v + world.field_73012_v.nextGaussian() * 10.0);
                if (entityLiving.field_70163_u <= 1.0) {
                    ((EntityPlayer)entityLiving).func_70634_a(entityLiving.field_70165_t, 3.0, entityLiving.field_70161_v);
                }
            } else {
                entityLiving.func_70634_a(entityLiving.field_70165_t + world.field_73012_v.nextGaussian() * 10.0, entityLiving.field_70163_u + world.field_73012_v.nextGaussian() * 10.0, entityLiving.field_70161_v + world.field_73012_v.nextGaussian() * 10.0);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
        if (this == DTBlocks.TRAP_AMBUSH && (list = world.func_72872_a(EntityLiving.class, axisalignedbb = new AxisAlignedBB((double)(pos.func_177958_n() - 4), (double)(pos.func_177956_o() - 2), (double)(pos.func_177952_p() - 3), (double)(pos.func_177958_n() + 5), (double)(pos.func_177956_o() + 3), (double)(pos.func_177952_p() + 5)))).size() < 16) {
            for (int i = 0; i < 4; ++i) {
                Entity newSpawn = EntityList.func_188429_b((ResourceLocation)this.pickMob(world.field_73012_v), (World)world);
                EntityLiving spawn = (EntityLiving)newSpawn;
                if (spawn != null) {
                    this.entityPlacement(world, pos, spawn);
                    world.func_72838_d((Entity)spawn);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.2f, world.field_73012_v.nextFloat());
            }
        }
        if (this == DTBlocks.TRAP_SPECTRAL) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 200, 0));
            world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void doParticles(World world, BlockPos pos) {
        int i;
        if (this == DTBlocks.TRAP_FIRE) {
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.4f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.4f), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.6f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.4f), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.4f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.6f), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.6f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.6f), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.4f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        }
        if (this == DTBlocks.TRAP_FOUL) {
            for (i = 0; i < 4; ++i) {
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.3f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.3f), 0.3, 0.5, 0.3, new int[0]);
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.7f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.3f), 0.3, 0.5, 0.3, new int[0]);
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.3f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.7f), 0.3, 0.5, 0.3, new int[0]);
                world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.7f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.7f), 0.3, 0.5, 0.3, new int[0]);
            }
        }
        if (this == DTBlocks.TRAP_AILMENT) {
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.5f), (double)((float)pos.func_177952_p() + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(pos.func_177977_b()))});
        }
        if (this == DTBlocks.TRAP_PORT) {
            for (i = 0; i < 30; ++i) {
                world.func_175688_a(EnumParticleTypes.PORTAL, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), new int[0]);
                world.func_175688_a(EnumParticleTypes.PORTAL, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f), world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian(), new int[0]);
            }
        }
        if (this == DTBlocks.TRAP_AMBUSH) {
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.3f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.3f), 0.8, 0.8, 0.6, new int[0]);
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.7f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.3f), 0.8, 0.8, 0.6, new int[0]);
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.3f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.7f), 0.8, 0.8, 0.6, new int[0]);
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.7f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.7f), 0.8, 0.8, 0.6, new int[0]);
        }
        if (this == DTBlocks.TRAP_SPECTRAL) {
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.3f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.3f), 0.8, 0.8, 0.6, new int[0]);
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.7f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.3f), 0.8, 0.8, 0.6, new int[0]);
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.3f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.7f), 0.8, 0.8, 0.6, new int[0]);
            world.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.7f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.7f), 0.8, 0.8, 0.6, new int[0]);
        }
    }

    private void entityPlacement(World world, BlockPos pos, EntityLiving entityLiving) {
        double x = (double)pos.func_177958_n() + world.field_73012_v.nextGaussian() - world.field_73012_v.nextGaussian();
        double z = (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() - world.field_73012_v.nextGaussian();
        float yaw = world.field_73012_v.nextFloat() * 360.0f;
        entityLiving.func_70012_b(x, (double)pos.func_177956_o(), z, yaw, 0.0f);
        entityLiving.field_70759_as = entityLiving.field_70177_z;
        entityLiving.field_70761_aq = entityLiving.field_70177_z;
        entityLiving.func_180482_a(world.func_175649_E(pos), (IEntityLivingData)null);
    }

    private ResourceLocation pickMob(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return new ResourceLocation("bat");
            }
            case 1: {
                return new ResourceLocation("zombie");
            }
            case 2: {
                return new ResourceLocation("zombie_villager");
            }
            case 3: {
                return new ResourceLocation("husk");
            }
            case 4: {
                return new ResourceLocation("zombie_pigman");
            }
            case 5: {
                return new ResourceLocation("skeleton");
            }
            case 6: {
                return new ResourceLocation("stray");
            }
            case 7: {
                return new ResourceLocation("witch");
            }
            case 8: {
                return new ResourceLocation("spider");
            }
            case 9: {
                return new ResourceLocation("cave_spider");
            }
        }
        return new ResourceLocation("squid");
    }
}

