/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.blocks.DTBlockGeneric;
import pegbeard.dungeontactics.blocks.tileentities.DTBrazierTile;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.items.DTSoulgem;

public class DTBrazier
extends DTBlockGeneric
implements ITileEntityProvider {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.253, 0.0, 0.253, 0.747, 0.56, 0.747);

    public DTBrazier(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT});
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this == DTBlocks.BRAZIER) {
            return new DTBrazierTile();
        }
        return null;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this == DTBlocks.BRAZIER) {
            boolean b = (Boolean)state.func_177229_b((IProperty)LIT);
            ((DTBrazierTile)world.func_175625_s(pos)).setLit(b);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            double startx = (double)pos.func_177958_n() + 0.5;
            double starty = (double)pos.func_177956_o() + 0.4;
            double startz = (double)pos.func_177952_p() + 0.5;
            for (int i = 0; i < 3; ++i) {
                world.func_175688_a(EnumParticleTypes.FLAME, startx, starty + 0.1, startz, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, startx - 0.13, starty, startz - 0.13, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, startx + 0.13, starty, startz - 0.13, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, startx - 0.13, starty, startz + 0.13, 0.0, 0.0, 0.0, new int[0]);
                world.func_175688_a(EnumParticleTypes.FLAME, startx + 0.13, starty, startz + 0.13, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemMonsterPlacer && state.func_177230_c() == DTBlocks.BRAZIER && (tileentity = world.func_175625_s(pos)) instanceof DTBrazierTile) {
            ((DTBrazierTile)tileentity).reset(stack, state, pos);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_77973_b() instanceof DTSoulgem && DTSoulgem.getSoulIdFrom(stack) != null && state.func_177230_c() == DTBlocks.BRAZIER) {
            if (DTSoulgem.getSoulLevelFrom(stack) < 50) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Soul Power too low."));
                return true;
            }
            tileentity = world.func_175625_s(pos);
            if (tileentity instanceof DTBrazierTile) {
                ((DTBrazierTile)tileentity).reset(stack, state, pos);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_184437_d(stack);
                }
                return true;
            }
        }
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && stack.func_77973_b() == Items.field_151033_d) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), 2);
            this.func_149715_a(1.0f);
            world.func_180500_c(EnumSkyBlock.BLOCK, pos);
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && stack.func_190926_b()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 2);
            this.func_149715_a(0.0f);
            world.func_180500_c(EnumSkyBlock.BLOCK, pos);
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        return false;
    }
}

