/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.entity.ai;

import doggytalents.DoggyTalents;
import doggytalents.api.feature.EnumGender;
import doggytalents.entity.EntityDog;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class DogLocationManager
extends WorldSavedData {
    private List<DogLocation> locations = new ArrayList<DogLocation>();

    public DogLocationManager(String name) {
        super(name);
    }

    public List<DogLocation> getList(int dim, Predicate<DogLocation> selector) {
        return this.getStream(dim, selector).collect(Collectors.toList());
    }

    public Stream<DogLocation> getStream(int dim, Predicate<DogLocation> selector) {
        return this.locations.stream().filter(loc -> loc.dim == dim).filter(selector);
    }

    public List<DogLocation> getAll(Predicate<DogLocation> selector) {
        return this.locations.stream().filter(selector).collect(Collectors.toList());
    }

    public static DogLocationManager getHandler(World world) {
        if (world.func_73046_m() == null) {
            DoggyTalents.LOGGER.warn("Called DogLocation#getHandler on the client, this shouldn't happen");
            return null;
        }
        MapStorage storage = world.func_73046_m().func_71218_a(0).func_175693_T();
        DogLocationManager locationManager = (DogLocationManager)storage.func_75742_a(DogLocationManager.class, "dog_locations");
        if (locationManager == null) {
            locationManager = new DogLocationManager("dog_locations");
            storage.func_75745_a("dog_locations", (WorldSavedData)locationManager);
        }
        return locationManager;
    }

    public void update(EntityDog dog) {
        DogLocation temp = new DogLocation(dog);
        int index = this.locations.indexOf(temp);
        if (index >= 0) {
            this.locations.set(index, temp);
        } else {
            DoggyTalents.LOGGER.debug("ADDED NEW DATA: " + temp);
            this.locations.add(temp);
        }
        this.func_76185_a();
    }

    public void remove(EntityDog dog) {
        DogLocation temp = new DogLocation(dog);
        if (this.locations.remove(temp)) {
            this.func_76185_a();
            DoggyTalents.LOGGER.debug("REMOVED DATA: " + temp);
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_150297_b("dog_locations", 9)) {
            NBTTagList nbtlist = nbt.func_150295_c("dog_locations", 10);
            for (int i = 0; i < nbtlist.func_74745_c(); ++i) {
                DogLocation location = new DogLocation(nbtlist.func_150305_b(i));
                DoggyTalents.LOGGER.debug("Loaded: " + location);
                if (location.entityId == null) continue;
                this.locations.add(location);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound base = new NBTTagCompound();
        NBTTagList nbtlist = new NBTTagList();
        for (DogLocation location : this.locations) {
            nbtlist.func_74742_a((NBTBase)location.writeToNBT(new NBTTagCompound()));
        }
        base.func_74782_a("dog_locations", (NBTBase)nbtlist);
        return base;
    }

    public class DogLocation {
        @Nonnull
        private UUID entityId;
        public double x;
        public double y;
        public double z;
        public int dim;
        @Nullable
        private UUID owner;
        private ITextComponent name;
        private EnumGender gender;
        private boolean hasRadarCollar;

        public DogLocation(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }

        public DogLocation(EntityDog dog) {
            this.x = dog.field_70165_t;
            this.y = dog.field_70163_u;
            this.z = dog.field_70161_v;
            this.dim = dog.field_70170_p.field_73011_w.getDimension();
            this.entityId = dog.func_110124_au();
            this.owner = dog.func_184753_b();
            this.name = dog.func_145748_c_();
            this.gender = dog.getGender();
            this.hasRadarCollar = dog.hasRadarCollar();
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.x = compound.func_74769_h("x");
            this.y = compound.func_74769_h("y");
            this.z = compound.func_74769_h("z");
            this.dim = compound.func_74762_e("dim");
            this.entityId = compound.func_186857_a("entityId");
            if (compound.func_186855_b("ownerId")) {
                this.owner = compound.func_186857_a("ownerId");
            }
            if (compound.func_150297_b("name_text_component", 8)) {
                this.name = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("name_text_component"));
            } else if (compound.func_150297_b("name", 8)) {
                this.name = new TextComponentString(compound.func_74779_i("name"));
            }
            this.gender = EnumGender.bySaveName(compound.func_74779_i("gender"));
            this.hasRadarCollar = compound.func_74767_n("collar");
        }

        public NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74780_a("x", this.x);
            compound.func_74780_a("y", this.y);
            compound.func_74780_a("z", this.z);
            compound.func_74768_a("dim", this.dim);
            compound.func_186854_a("entityId", this.entityId);
            if (this.owner != null) {
                compound.func_186854_a("ownerId", this.owner);
            }
            compound.func_74778_a("name_text_component", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
            compound.func_74778_a("gender", this.gender.getSaveName());
            compound.func_74757_a("collar", this.hasRadarCollar);
            return compound;
        }

        public EntityDog getDog(World world) {
            if (!(world instanceof WorldServer)) {
                DoggyTalents.LOGGER.warn("Something when wrong. Tried to call DogLocation#getDog(EntityPlayer) on what looks like the client side");
                return null;
            }
            Entity entity = ((WorldServer)world).func_175733_a(this.entityId);
            if (entity == null) {
                return null;
            }
            if (!(entity instanceof EntityDog)) {
                DoggyTalents.LOGGER.warn("Something when wrong. The saved dog UUID is not an EntityDog");
                return null;
            }
            return (EntityDog)entity;
        }

        public EntityLivingBase getOwner(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.func_70902_q();
            }
            if (this.owner != null) {
                return world.func_152378_a(this.owner);
            }
            return null;
        }

        public ITextComponent getName(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.func_145748_c_();
            }
            if (this.owner != null) {
                return this.name;
            }
            return null;
        }

        public boolean hasRadioCollar(World world) {
            EntityDog dog = this.getDog(world);
            if (dog != null) {
                return dog.hasRadarCollar();
            }
            return this.hasRadarCollar;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DogLocation)) {
                return false;
            }
            DogLocation other = (DogLocation)obj;
            return this.entityId != null && other.entityId != null && this.entityId.equals(other.entityId);
        }

        public String toString() {
            return String.format("DogLocation [x=%f,y=%f, z=%f, dim=%d]", this.x, this.y, this.z, this.dim);
        }
    }
}

