/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.IntrusiveEdgesSpecifics;
import org.jgrapht.graph.UniformIntrusiveEdgesSpecifics;
import org.jgrapht.graph.WeightedIntrusiveEdgesSpecifics;
import org.jgrapht.graph.specifics.FastLookupDirectedSpecifics;
import org.jgrapht.graph.specifics.FastLookupUndirectedSpecifics;
import org.jgrapht.graph.specifics.Specifics;
import org.jgrapht.util.TypeUtil;

public abstract class AbstractBaseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4811000483921413364L;
    private static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    private static final String GRAPH_SPECIFICS_MUST_NOT_BE_NULL = "Graph specifics must not be null";
    private EdgeFactory<V, E> edgeFactory;
    private transient Set<V> unmodifiableVertexSet = null;
    private Specifics<V, E> specifics;
    private IntrusiveEdgesSpecifics<V, E> intrusiveEdgesSpecifics;
    private boolean directed;
    private boolean weighted;
    private boolean allowingMultipleEdges;
    private boolean allowingLoops;

    @Deprecated
    protected AbstractBaseGraph(EdgeFactory<V, E> ef, boolean allowMultipleEdges, boolean allowLoops) {
        Objects.requireNonNull(ef);
        this.edgeFactory = ef;
        this.allowingLoops = allowLoops;
        this.allowingMultipleEdges = allowMultipleEdges;
        this.specifics = Objects.requireNonNull(this.createSpecifics(), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
        if (this instanceof DirectedGraph) {
            this.directed = true;
        } else if (this instanceof UndirectedGraph) {
            this.directed = false;
        } else {
            throw new IllegalArgumentException("Graph must be either directed or undirected");
        }
        this.weighted = false;
        this.intrusiveEdgesSpecifics = Objects.requireNonNull(this.createIntrusiveEdgesSpecifics(false), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
    }

    protected AbstractBaseGraph(EdgeFactory<V, E> ef, boolean directed, boolean allowMultipleEdges, boolean allowLoops, boolean weighted) {
        Objects.requireNonNull(ef);
        this.edgeFactory = ef;
        this.allowingLoops = allowLoops;
        this.allowingMultipleEdges = allowMultipleEdges;
        this.directed = directed;
        this.specifics = Objects.requireNonNull(this.createSpecifics(directed), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
        this.weighted = weighted;
        this.intrusiveEdgesSpecifics = Objects.requireNonNull(this.createIntrusiveEdgesSpecifics(weighted), GRAPH_SPECIFICS_MUST_NOT_BE_NULL);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        return this.specifics.getAllEdges(sourceVertex, targetVertex);
    }

    public boolean isAllowingLoops() {
        return this.allowingLoops;
    }

    public boolean isAllowingMultipleEdges() {
        return this.allowingMultipleEdges;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        return this.specifics.getEdge(sourceVertex, targetVertex);
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.edgeFactory;
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.allowingMultipleEdges && this.containsEdge(sourceVertex, targetVertex)) {
            return null;
        }
        if (!this.allowingLoops && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        E e = this.edgeFactory.createEdge(sourceVertex, targetVertex);
        if (this.containsEdge(e)) {
            return null;
        }
        this.intrusiveEdgesSpecifics.add(e, sourceVertex, targetVertex);
        this.specifics.addEdgeToTouchingVertices(e);
        return e;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(e)) {
            return false;
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.allowingMultipleEdges && this.containsEdge(sourceVertex, targetVertex)) {
            return false;
        }
        if (!this.allowingLoops && sourceVertex.equals(targetVertex)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        this.intrusiveEdgesSpecifics.add(e, sourceVertex, targetVertex);
        this.specifics.addEdgeToTouchingVertices(e);
        return true;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.specifics.addVertex(v);
        return true;
    }

    @Override
    public V getEdgeSource(E e) {
        return this.intrusiveEdgesSpecifics.getEdgeSource(e);
    }

    @Override
    public V getEdgeTarget(E e) {
        return this.intrusiveEdgesSpecifics.getEdgeTarget(e);
    }

    public Object clone() {
        try {
            AbstractBaseGraph newGraph = (AbstractBaseGraph)TypeUtil.uncheckedCast(super.clone(), null);
            newGraph.edgeFactory = this.edgeFactory;
            newGraph.unmodifiableVertexSet = null;
            newGraph.specifics = newGraph.createSpecifics(this.directed);
            newGraph.intrusiveEdgesSpecifics = newGraph.createIntrusiveEdgesSpecifics(this.weighted);
            Graphs.addGraph(newGraph, this);
            return newGraph;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public boolean containsEdge(E e) {
        return this.intrusiveEdgesSpecifics.containsEdge(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.specifics.getVertexSet().contains(v);
    }

    @Override
    public int degreeOf(V vertex) {
        return this.specifics.degreeOf(vertex);
    }

    @Override
    public Set<E> edgeSet() {
        return this.intrusiveEdgesSpecifics.getEdgeSet();
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.edgesOf(vertex);
    }

    @Override
    public int inDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.inDegreeOf(vertex);
    }

    @Override
    public Set<E> incomingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.incomingEdgesOf(vertex);
    }

    @Override
    public int outDegreeOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.outDegreeOf(vertex);
    }

    @Override
    public Set<E> outgoingEdgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.specifics.outgoingEdgesOf(vertex);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        E e = this.getEdge(sourceVertex, targetVertex);
        if (e != null) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.intrusiveEdgesSpecifics.remove(e);
        }
        return e;
    }

    @Override
    public boolean removeEdge(E e) {
        if (this.containsEdge(e)) {
            this.specifics.removeEdgeFromTouchingVertices(e);
            this.intrusiveEdgesSpecifics.remove(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set<E> touchingEdgesList = this.edgesOf(v);
            this.removeAllEdges(new ArrayList<E>(touchingEdgesList));
            this.specifics.getVertexSet().remove(v);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.specifics.getVertexSet());
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public double getEdgeWeight(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.intrusiveEdgesSpecifics.getEdgeWeight(e);
    }

    @Override
    public void setEdgeWeight(E e, double weight) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.intrusiveEdgesSpecifics.setEdgeWeight(e, weight);
    }

    @Override
    public GraphType getType() {
        if (this.directed) {
            return new DefaultGraphType.Builder().directed().weighted(this.weighted).allowMultipleEdges(this.allowingMultipleEdges).allowSelfLoops(this.allowingLoops).build();
        }
        return new DefaultGraphType.Builder().undirected().weighted(this.weighted).allowMultipleEdges(this.allowingMultipleEdges).allowSelfLoops(this.allowingLoops).build();
    }

    @Deprecated
    protected Specifics<V, E> createSpecifics() {
        if (this instanceof DirectedGraph) {
            return new FastLookupDirectedSpecifics(this);
        }
        if (this instanceof UndirectedGraph) {
            return new FastLookupUndirectedSpecifics(this);
        }
        throw new IllegalArgumentException("must be instance of either DirectedGraph or UndirectedGraph");
    }

    protected Specifics<V, E> createSpecifics(boolean directed) {
        try {
            return this.createSpecifics();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (directed) {
                return new FastLookupDirectedSpecifics(this);
            }
            return new FastLookupUndirectedSpecifics(this);
        }
    }

    protected IntrusiveEdgesSpecifics<V, E> createIntrusiveEdgesSpecifics(boolean weighted) {
        if (weighted) {
            return new WeightedIntrusiveEdgesSpecifics();
        }
        return new UniformIntrusiveEdgesSpecifics();
    }
}

