/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.pocketlib;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.ddutils.math.GridUtils;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.WorldProviderPocket;

public class PocketRegistry
extends WorldSavedData {
    private static final String DATA_NAME = "pocketlib_pockets";
    int gridSize;
    int privatePocketSize;
    int publicPocketSize;
    Map<Integer, Pocket> pockets;
    int nextID;
    private int dim;

    public PocketRegistry() {
        super(DATA_NAME);
    }

    public PocketRegistry(String s) {
        super(s);
    }

    public static PocketRegistry instance(int dim) {
        WorldServer world = WorldUtils.getWorld(dim);
        if (!(world.field_73011_w instanceof WorldProviderPocket)) {
            throw new UnsupportedOperationException("PocketRegistry is only available for pocket dimensions (asked for dim " + dim + ")!");
        }
        MapStorage storage = world.getPerWorldStorage();
        PocketRegistry instance = (PocketRegistry)storage.func_75742_a(PocketRegistry.class, DATA_NAME);
        if (instance == null || instance.pockets == null) {
            instance = new PocketRegistry();
            instance.initNewRegistry();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        instance.dim = dim;
        for (Pocket pocket : instance.pockets.values()) {
            pocket.dim = dim;
        }
        return instance;
    }

    public void initNewRegistry() {
        this.gridSize = ModConfig.pockets.pocketGridSize;
        this.nextID = 0;
        this.pockets = new HashMap<Integer, Pocket>();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTUtils.readFromNBT(this, nbt);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        return NBTUtils.writeToNBT((Object)this, nbt);
    }

    public Pocket newPocket() {
        Pocket pocket = null;
        while (pocket == null) {
            pocket = this.newPocket(this.nextID++);
        }
        return pocket;
    }

    public Pocket newPocket(int id) {
        if (this.pockets.get(id) != null) {
            return null;
        }
        GridUtils.GridPos pos = this.idToGridPos(id);
        Pocket pocket = new Pocket(id, this.dim, pos.getX(), pos.getZ());
        this.pockets.put(id, pocket);
        if (id >= this.nextID) {
            this.nextID = id + 1;
        }
        this.func_76185_a();
        return pocket;
    }

    public void removePocket(int id) {
        this.pockets.remove(id);
        this.func_76185_a();
    }

    public Pocket getPocket(int id) {
        return this.pockets.get(id);
    }

    public GridUtils.GridPos idToGridPos(int id) {
        return GridUtils.numToPos(id);
    }

    public int gridPosToID(GridUtils.GridPos pos) {
        return GridUtils.posToNum(pos);
    }

    public BlockPos idToPos(int id) {
        GridUtils.GridPos pos = this.idToGridPos(id);
        return new BlockPos(pos.getX() * this.gridSize * 16, 0, pos.getZ() * this.gridSize * 16);
    }

    public int posToID(BlockPos pos) {
        return this.gridPosToID(new GridUtils.GridPos(pos.func_177958_n() / (this.gridSize * 16), pos.func_177952_p() / (this.gridSize * 16)));
    }

    public Pocket getPocketAt(BlockPos pos) {
        return this.getPocket(this.posToID(pos));
    }

    public boolean isWithinPocketBounds(BlockPos pos) {
        Pocket pocket = this.getPocketAt(pos);
        return pocket != null && pocket.isInBounds(pos);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPrivatePocketSize() {
        return this.privatePocketSize;
    }

    public int getPublicPocketSize() {
        return this.publicPocketSize;
    }

    public Map<Integer, Pocket> getPockets() {
        return this.pockets;
    }

    public int getNextID() {
        return this.nextID;
    }

    public int getDim() {
        return this.dim;
    }
}

