/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world;

import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.world.limbo.WorldProviderLimbo;
import org.dimdev.dimdoors.shared.world.pocketdimension.WorldProviderDungeonPocket;
import org.dimdev.dimdoors.shared.world.pocketdimension.WorldProviderPersonalPocket;
import org.dimdev.dimdoors.shared.world.pocketdimension.WorldProviderPublicPocket;

public final class ModDimensions {
    public static final DimensionType LIMBO = DimensionType.register((String)"limbo", (String)"_limbo", (int)684, WorldProviderLimbo.class, (boolean)false);
    public static final DimensionType PRIVATE = DimensionType.register((String)"private_pockets", (String)"_private", (int)685, WorldProviderPersonalPocket.class, (boolean)false);
    public static final DimensionType PUBLIC = DimensionType.register((String)"public_pockets", (String)"_public", (int)686, WorldProviderPublicPocket.class, (boolean)false);
    public static final DimensionType DUNGEON = DimensionType.register((String)"dungeon_pockets", (String)"_dungeon", (int)687, WorldProviderDungeonPocket.class, (boolean)false);
    private static int limboDim;
    private static int privateDim;
    private static int publicDim;
    private static int dungeonDim;
    private static int dungeonMakingDim;

    public static void registerDimensions() {
        int dim = ModConfig.general.baseDimensionID;
        limboDim = dim++;
        privateDim = dim++;
        publicDim = dim++;
        dungeonDim = dim++;
        dungeonMakingDim = dim++;
        DimensionManager.registerDimension((int)limboDim, (DimensionType)LIMBO);
        DimensionManager.registerDimension((int)privateDim, (DimensionType)PRIVATE);
        DimensionManager.registerDimension((int)publicDim, (DimensionType)PUBLIC);
        DimensionManager.registerDimension((int)dungeonDim, (DimensionType)DUNGEON);
        DimensionManager.registerDimension((int)dungeonMakingDim, (DimensionType)DUNGEON);
    }

    public static boolean isDimDoorsPocketDimension(int id) {
        return id == privateDim || id == publicDim || id == dungeonDim;
    }

    public static boolean isDimDoorsDimension(int id) {
        return id == privateDim || id == publicDim || id == dungeonDim || id == limboDim || id == dungeonMakingDim;
    }

    public static boolean isDimDoorsPocketDimension(World world) {
        return world.field_73011_w instanceof WorldProviderPublicPocket || world.field_73011_w instanceof WorldProviderPersonalPocket || world.field_73011_w instanceof WorldProviderDungeonPocket;
    }

    public static int getLimboDim() {
        return limboDim;
    }

    public static int getPrivateDim() {
        return privateDim;
    }

    public static int getPublicDim() {
        return publicDim;
    }

    public static int getDungeonDim() {
        return dungeonDim;
    }

    public static int getDungeonMakingDim() {
        return dungeonMakingDim;
    }
}

