/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.tileentities;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RGBA;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.pockets.PocketTemplate;
import org.dimdev.dimdoors.shared.rifts.registry.LinkProperties;
import org.dimdev.dimdoors.shared.rifts.registry.Rift;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.IEntityTarget;
import org.dimdev.dimdoors.shared.rifts.targets.ITarget;
import org.dimdev.dimdoors.shared.rifts.targets.MessageTarget;
import org.dimdev.dimdoors.shared.rifts.targets.Targets;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.pocketlib.VirtualLocation;

public abstract class TileEntityRift
extends TileEntity
implements ITarget,
IEntityTarget {
    @Nonnull
    VirtualTarget destination;
    protected LinkProperties properties;
    protected boolean relativeRotation = true;
    protected boolean alwaysDelete = false;
    protected boolean forcedColor;
    protected RGBA color = null;
    protected boolean riftStateChanged;

    public void copyFrom(TileEntityRift oldRift) {
        this.relativeRotation = oldRift.relativeRotation;
        this.properties = oldRift.properties;
        this.destination = oldRift.destination;
        if (oldRift.isFloating() != this.isFloating()) {
            this.updateType();
        }
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTUtils.readFromNBT(this, nbt);
        this.destination = nbt.func_74764_b("destination") ? VirtualTarget.readVirtualTargetNBT(nbt.func_74775_l("destination")) : null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.destination != null) {
            nbt.func_74782_a("destination", (NBTBase)this.destination.writeToNBT(new NBTTagCompound()));
        }
        return NBTUtils.writeToNBT(this, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.deserializeNBT(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.serializeNBT());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.deserializeNBT(pkt.func_148857_g());
    }

    public void setRelativeRotation(boolean relativeRotation) {
        this.relativeRotation = relativeRotation;
        this.func_70296_d();
    }

    public void setDestination(VirtualTarget destination) {
        if (this.destination != null && this.isRegistered()) {
            this.destination.unregister();
        }
        this.destination = destination;
        if (destination != null) {
            if (this.field_145850_b != null && this.field_174879_c != null) {
                destination.setLocation(new Location(this.field_145850_b, this.field_174879_c));
            }
            if (this.isRegistered()) {
                destination.register();
            }
        }
        this.riftStateChanged = true;
        this.func_70296_d();
        this.updateColor();
    }

    public void setColor(RGBA color) {
        this.forcedColor = color != null;
        this.color = color;
        this.func_70296_d();
    }

    public void setProperties(LinkProperties properties) {
        this.properties = properties;
        this.updateProperties();
        this.func_70296_d();
    }

    public void markStateChanged() {
        this.riftStateChanged = true;
        this.func_70296_d();
    }

    public boolean isRegistered() {
        return DimensionManager.getWorld((int)0) != null && !PocketTemplate.isReplacingPlaceholders() && RiftRegistry.instance().isRiftAt(new Location(this.field_145850_b, this.field_174879_c));
    }

    public void register() {
        if (this.isRegistered()) {
            return;
        }
        Location loc = new Location(this.field_145850_b, this.field_174879_c);
        RiftRegistry.instance().addRift(loc);
        if (this.destination != null) {
            this.destination.register();
        }
        this.updateProperties();
        this.updateColor();
    }

    public void updateProperties() {
        if (this.isRegistered()) {
            RiftRegistry.instance().setProperties(new Location(this.field_145850_b, this.field_174879_c), this.properties);
        }
        this.func_70296_d();
    }

    public void unregister() {
        if (this.isRegistered()) {
            RiftRegistry.instance().removeRift(new Location(this.field_145850_b, this.field_174879_c));
        }
    }

    public void updateType() {
        if (!this.isRegistered()) {
            return;
        }
        Location loc = new Location(this.field_145850_b, this.field_174879_c);
        if (RiftRegistry.instance().isRiftAt(loc)) {
            DimDoors.log.error("No rift at location " + loc + " to update!");
            return;
        }
        Rift rift = RiftRegistry.instance().getRift(loc);
        rift.isFloating = this.isFloating();
        rift.markDirty();
    }

    public void targetGone(Location location) {
        if (this.destination.shouldInvalidate(location)) {
            this.destination = null;
            this.func_70296_d();
        }
        this.updateColor();
    }

    public void sourceGone(Location loc) {
        this.updateColor();
    }

    public ITarget getTarget() {
        if (this.destination == null) {
            return new MessageTarget("rifts.unlinked", new Object[0]);
        }
        this.destination.setLocation(new Location(this.field_145850_b, this.field_174879_c));
        return this.destination;
    }

    public boolean teleport(Entity entity) {
        this.riftStateChanged = false;
        try {
            IEntityTarget target = this.getTarget().as(Targets.ENTITY);
            if (target.receiveEntity(entity, this.getSourceYaw(entity.field_70177_z), this.getSourcePitch(entity.field_70125_A))) {
                VirtualLocation vloc = VirtualLocation.fromLocation(new Location(entity.field_70170_p, entity.func_180425_c()));
                DimDoors.sendTranslatedMessage(entity, "You are at x = " + vloc.getX() + ", y = ?, z = " + vloc.getZ() + ", w = " + vloc.getDepth(), new Object[0]);
                return true;
            }
        }
        catch (Exception e) {
            DimDoors.chat(entity, "Something went wrong while trying to teleport you, please report this bug.", new Object[0]);
            DimDoors.log.error("Teleporting failed with the following exception: ", (Throwable)e);
        }
        return false;
    }

    public void updateColor() {
        if (this.forcedColor) {
            return;
        }
        if (!this.isRegistered()) {
            this.color = new RGBA(0.0f, 0.0f, 0.0f, 1.0f);
        } else if (this.destination == null) {
            this.color = new RGBA(0.7f, 0.7f, 0.7f, 1.0f);
        } else {
            this.destination.setLocation(new Location(this.field_145850_b, this.field_174879_c));
            RGBA newColor = this.destination.getColor();
            if (this.color == null && newColor != null || !this.color.equals(newColor)) {
                this.color = newColor;
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            }
        }
    }

    protected abstract boolean isFloating();

    public abstract float getSourceYaw(float var1);

    public abstract float getSourcePitch(float var1);

    public abstract float getDestinationYaw(float var1);

    public abstract float getDestinationPitch(float var1);

    @Nonnull
    public VirtualTarget getDestination() {
        return this.destination;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    public boolean isRelativeRotation() {
        return this.relativeRotation;
    }

    public boolean isAlwaysDelete() {
        return this.alwaysDelete;
    }

    public boolean isForcedColor() {
        return this.forcedColor;
    }

    public RGBA getColor() {
        return this.color;
    }
}

