/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.tileentities;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.ddutils.lsystem.LSystem;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.BlockFloatingRift;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;
import org.dimdev.dimdoors.shared.world.RiftDecay;

public class TileEntityFloatingRift
extends TileEntityRift
implements ITickable {
    private static final int ENDERMAN_SPAWNING_CHANCE = 1;
    private static final int MAX_ENDERMAN_SPAWNING_CHANCE = 32;
    private static final int HOSTILE_ENDERMAN_CHANCE = 1;
    private static final int MAX_HOSTILE_ENDERMAN_CHANCE = 3;
    private static final int UPDATE_PERIOD = 200;
    private static final Random random = new Random();
    public boolean closing = false;
    public boolean stabilized = false;
    public int spawnedEndermenID = 0;
    public float size = 0.0f;
    public float riftYaw = random.nextInt(360);
    protected float teleportTargetPitch;
    public int curveId = random.nextInt(LSystem.curves.size());
    private boolean unregisterDisabled = false;
    int updateTimer = random.nextInt(200);
    @SideOnly(value=Side.CLIENT)
    public double renderAngle;
    @SideOnly(value=Side.CLIENT)
    private int cachedCurveId;
    @SideOnly(value=Side.CLIENT)
    private LSystem.PolygonInfo curve;

    public TileEntityFloatingRift() {
        if (DimDoors.proxy.isClient()) {
            this.cachedCurveId = -1;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != ModBlocks.RIFT) {
            this.func_145843_s();
            return;
        }
        if (ModConfig.rifts.enableRifts) {
            if (this.updateTimer >= 200) {
                this.spawnEndermen();
                this.updateTimer = 0;
            } else if (this.updateTimer == 100) {
                this.updateNearestRift();
            }
            ++this.updateTimer;
            if (this.closing) {
                if (this.size > 0.0f) {
                    this.size -= ModConfig.rifts.riftCloseSpeed;
                } else {
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                }
            } else if (!this.stabilized) {
                for (int n = 0; n < 10; ++n) {
                    this.size += 1.0f / (this.size + 1.0f);
                }
                if (!this.field_145850_b.field_72995_K && ModConfig.rifts.enableRiftDecay) {
                    RiftDecay.applySpreadDecay(this.field_145850_b, this.field_174879_c, this);
                }
            }
        } else {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    private void spawnEndermen() {
        List list;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Entity entity = this.field_145850_b.func_73045_a(this.spawnedEndermenID);
        if (entity instanceof EntityEnderman) {
            return;
        }
        if (random.nextInt(32) < 1 && this.updateNearestRift() && (list = this.field_145850_b.func_72872_a(EntityEnderman.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 9), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 9), (double)(this.field_174879_c.func_177958_n() + 9), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 9)))).isEmpty()) {
            EntityPlayer player;
            EntityEnderman enderman = new EntityEnderman(this.field_145850_b);
            enderman.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p() + 0.5, 5.0f, 6.0f);
            this.field_145850_b.func_72838_d((Entity)enderman);
            if (random.nextInt(3) < 1 && (player = this.field_145850_b.func_72890_a((Entity)enderman, 50.0)) != null) {
                enderman.func_70624_b((EntityLivingBase)player);
            }
        }
    }

    public boolean updateNearestRift() {
        return false;
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 0);
        this.func_70296_d();
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 0);
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        newSate = world.func_180495_p(pos);
        return oldState.func_177230_c() != newSate.func_177230_c() && (!(world.func_175625_s(pos) instanceof TileEntityRift) || !(newSate.func_177230_c() instanceof BlockFloatingRift));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        return NBTUtils.writeToNBT(this, nbt);
    }

    @Override
    public boolean isFloating() {
        return true;
    }

    @Override
    public void unregister() {
        if (!this.unregisterDisabled) {
            super.unregister();
        }
    }

    public void setTeleportTargetRotation(float yaw, float pitch) {
        this.riftYaw = yaw;
        this.teleportTargetPitch = pitch;
        this.func_70296_d();
    }

    @Override
    public boolean receiveEntity(Entity entity, float relativeYaw, float relativePitch) {
        if (this.relativeRotation) {
            float yaw = this.getDestinationYaw(entity.field_70177_z) + entity.field_70177_z - relativeYaw;
            float pitch = entity instanceof EntityLiving ? entity.field_70125_A : this.getDestinationPitch(entity.field_70125_A) + entity.field_70125_A - relativePitch;
            TeleportUtils.teleport(entity, new Location(this.field_145850_b, this.field_174879_c), yaw, pitch);
        } else {
            TeleportUtils.teleport(entity, new Location(this.field_145850_b, this.field_174879_c), this.getDestinationYaw(entity.field_70177_z), this.getDestinationPitch(entity.field_70125_A));
        }
        return true;
    }

    @Override
    public float getSourceYaw(float entityYaw) {
        return (int)(entityYaw / 90.0f) * 90;
    }

    @Override
    public float getSourcePitch(float entityPitch) {
        return 0.0f;
    }

    @Override
    public float getDestinationYaw(float entityYaw) {
        return this.riftYaw;
    }

    @Override
    public float getDestinationPitch(float entityPitch) {
        return this.teleportTargetPitch;
    }

    @SideOnly(value=Side.CLIENT)
    public LSystem.PolygonInfo getCurve() {
        if (this.curve != null && this.curveId == this.cachedCurveId) {
            return this.curve;
        }
        int numCurves = LSystem.curves.size();
        this.cachedCurveId = this.curveId;
        if (this.curveId < numCurves && this.curveId >= 0) {
            this.curve = LSystem.curves.get(this.curveId);
        } else {
            DimDoors.log.error("Curve ID out of bounds (ID: " + this.curveId + ", number of curves: " + numCurves + ")");
            this.curve = LSystem.curves.get(0);
        }
        return this.curve;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-50, -50, -50), this.field_174879_c.func_177982_a(50, 50, 50));
    }

    public void setUnregisterDisabled(boolean unregisterDisabled) {
        this.unregisterDisabled = unregisterDisabled;
    }
}

