/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RGBA;
import org.dimdev.ddutils.nbt.INBTStorable;
import org.dimdev.dimdoors.shared.rifts.targets.ITarget;

public abstract class VirtualTarget
implements ITarget,
INBTStorable {
    public static final BiMap<String, Class<? extends VirtualTarget>> registry = HashBiMap.create();
    protected Location location;

    public static VirtualTarget readVirtualTargetNBT(NBTTagCompound nbt) {
        String type = nbt.func_74779_i("type");
        Class destinationClass = (Class)registry.get((Object)type);
        if (destinationClass == null) {
            throw new RuntimeException("Unknown type '" + type + "'.");
        }
        try {
            VirtualTarget destination = (VirtualTarget)destinationClass.newInstance();
            destination.readFromNBT(nbt);
            return destination;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("The class registered for virtual target " + type + " must have a public no-args constructor and must not be abstract", e);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        String type = (String)registry.inverse().get(this.getClass());
        if (type == null) {
            throw new RuntimeException("No type has been registered for class" + this.getClass().getName());
        }
        nbt.func_74778_a("type", type);
        return nbt;
    }

    public void register() {
    }

    public void unregister() {
    }

    public boolean shouldInvalidate(Location riftDeleted) {
        return false;
    }

    public RGBA getColor() {
        return new RGBA(1.0f, 0.0f, 0.0f, 1.0f);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualTarget)) {
            return false;
        }
        VirtualTarget other = (VirtualTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Location this$location = this.location;
        Location other$location = other.location;
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VirtualTarget;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Location $location = this.location;
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    public String toString() {
        return "VirtualTarget(location=" + this.location + ")";
    }

    public void setLocation(Location location) {
        this.location = location;
    }
}

