/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RGBA;
import org.dimdev.dimdoors.shared.rifts.targets.ITarget;
import org.dimdev.dimdoors.shared.rifts.targets.RiftReference;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;

public abstract class RestoringTarget
extends VirtualTarget {
    private VirtualTarget wrappedDestination;

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.wrappedDestination = nbt.func_74764_b("wrappedDestination") ? VirtualTarget.readVirtualTargetNBT(nbt.func_74775_l("wrappedDestination")) : null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        if (this.wrappedDestination != null) {
            nbt.func_74782_a("wrappedDestination", (NBTBase)this.wrappedDestination.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public ITarget receiveOther() {
        if (this.wrappedDestination != null) {
            this.wrappedDestination.location = this.location;
            return this.wrappedDestination;
        }
        Location linkTarget = this.makeLinkTarget();
        if (linkTarget != null) {
            this.wrappedDestination = RiftReference.tryMakeLocal(this.location, linkTarget);
            this.wrappedDestination.setLocation(this.location);
            this.wrappedDestination.register();
            return this.wrappedDestination;
        }
        return null;
    }

    @Override
    public boolean shouldInvalidate(Location deletedRift) {
        if (this.wrappedDestination.shouldInvalidate(deletedRift)) {
            this.wrappedDestination.unregister();
        }
        return false;
    }

    @Override
    public void setLocation(Location location) {
        super.setLocation(location);
        if (this.wrappedDestination != null) {
            this.wrappedDestination.setLocation(location);
        }
    }

    @Override
    public void unregister() {
        if (this.wrappedDestination != null) {
            this.wrappedDestination.unregister();
        }
    }

    @Override
    public RGBA getColor() {
        if (this.wrappedDestination != null) {
            this.wrappedDestination.location = this.location;
            return this.wrappedDestination.getColor();
        }
        return this.getUnlinkedColor(this.location);
    }

    protected RGBA getUnlinkedColor(Location location) {
        return new RGBA(0.0f, 1.0f, 1.0f, 1.0f);
    }

    public abstract Location makeLinkTarget();
}

