/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.Location;
import org.dimdev.dimdoors.shared.pockets.PocketGenerator;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.GlobalReference;
import org.dimdev.dimdoors.shared.rifts.targets.RestoringTarget;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.VirtualLocation;

public class PublicPocketTarget
extends RestoringTarget {
    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public Location makeLinkTarget() {
        VirtualLocation riftVirtualLocation = VirtualLocation.fromLocation(this.location);
        VirtualLocation newVirtualLocation = null;
        if (riftVirtualLocation != null) {
            int depth = Math.max(riftVirtualLocation.getDepth(), 1);
            newVirtualLocation = riftVirtualLocation.toBuilder().depth(depth).build();
        }
        Pocket pocket = PocketGenerator.generatePublicPocket(newVirtualLocation, new GlobalReference(this.location), null);
        return RiftRegistry.instance().getPocketEntrance(pocket);
    }

    public static PublicPocketTargetBuilder builder() {
        return new PublicPocketTargetBuilder();
    }

    public PublicPocketTargetBuilder toBuilder() {
        return new PublicPocketTargetBuilder();
    }

    @Override
    public String toString() {
        return "PublicPocketTarget()";
    }

    public static class PublicPocketTargetBuilder {
        PublicPocketTargetBuilder() {
        }

        public PublicPocketTarget build() {
            return new PublicPocketTarget();
        }

        public String toString() {
            return "PublicPocketTarget.PublicPocketTargetBuilder()";
        }
    }
}

