/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.pockets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.dimdev.ddutils.math.MathUtils;
import org.dimdev.ddutils.schem.Schematic;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.pockets.PocketTemplate;

public class SchematicHandler {
    private static final String SAVED_POCKETS_GROUP_NAME = "saved_pockets";
    public static final SchematicHandler INSTANCE = new SchematicHandler();
    private List<PocketTemplate> templates;
    private Map<String, Map<String, Integer>> nameMap;
    private List<Map.Entry<PocketTemplate, Integer>> usageList = new ArrayList<Map.Entry<PocketTemplate, Integer>>();
    private Map<PocketTemplate, Integer> usageMap = new HashMap<PocketTemplate, Integer>();

    public Schematic loadSchematicFromByteArray(byte[] schematicBytecode) {
        Schematic schematic = null;
        try {
            schematic = Schematic.loadFromNBT(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(schematicBytecode)));
        }
        catch (IOException ex) {
            DimDoors.log.error("Schematic file for this dungeon could not be read from byte array.", (Throwable)ex);
        }
        return schematic;
    }

    public void loadSchematics() {
        File schematicFolder;
        String[] names;
        long startTime = System.currentTimeMillis();
        this.templates = new ArrayList<PocketTemplate>();
        for (String name : names = new String[]{"default_dungeon_nether", "default_dungeon_normal", "default_private", "default_public", "default_blank"}) {
            try {
                URL resource = DimDoors.class.getResource("/assets/dimdoors/pockets/json/" + name + ".json");
                String jsonString = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
                this.templates.addAll(SchematicHandler.loadTemplatesFromJson(jsonString));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        File jsonFolder = new File(DimDoors.getConfigurationFolder(), "/jsons");
        if (!jsonFolder.exists()) {
            jsonFolder.mkdirs();
        }
        if (!(schematicFolder = new File(DimDoors.getConfigurationFolder(), "/schematics")).exists()) {
            schematicFolder.mkdirs();
        }
        for (File file : jsonFolder.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".json")) continue;
            try {
                String jsonString = IOUtils.toString((URI)file.toURI(), (Charset)StandardCharsets.UTF_8);
                this.templates.addAll(SchematicHandler.loadTemplatesFromJson(jsonString));
            }
            catch (MalformedJsonException e) {
                DimDoors.log.error("Malformed JSON file for schematic " + file.getName() + ": " + (Object)((Object)e));
            }
            catch (IOException e) {
                DimDoors.log.error("Error reading file " + file.toURI() + ". The following exception occured: ", (Throwable)e);
            }
        }
        File saveFolder = new File(DimDoors.getConfigurationFolder(), "/schematics/saved");
        if (saveFolder.exists()) {
            for (File file : saveFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(".schem")) continue;
                try {
                    byte[] schematicBytecode = IOUtils.toByteArray((InputStream)new FileInputStream(file));
                    Schematic.loadFromNBT(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(schematicBytecode)));
                    PocketTemplate template = new PocketTemplate(SAVED_POCKETS_GROUP_NAME, file.getName(), null, null, null, null, schematicBytecode, -1, 0);
                    this.templates.add(template);
                }
                catch (MalformedJsonException e) {
                    DimDoors.log.error("Malformed JSON file for schematic " + file.getName() + ": " + (Object)((Object)e));
                }
                catch (IOException e) {
                    DimDoors.log.error("Error reading schematic " + file.getName() + ": " + e);
                }
            }
        }
        this.constructNameMap();
        DimDoors.log.info("Loaded " + this.templates.size() + " templates in " + (System.currentTimeMillis() - startTime) + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PocketTemplate> loadTemplatesFromJson(String jsonString) {
        String schematicJarDirectory = "/assets/dimdoors/pockets/schematic/";
        File schematicFolder = new File(DimDoors.getConfigurationFolder(), "/schematics");
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(jsonString);
        JsonObject jsonTemplate = jsonElement.getAsJsonObject();
        List<PocketTemplate> candidateTemplates = SchematicHandler.getAllValidVariations(jsonTemplate);
        String subDirectory = jsonTemplate.get("group").getAsString();
        ArrayList<PocketTemplate> validTemplates = new ArrayList<PocketTemplate>();
        for (PocketTemplate template : candidateTemplates) {
            String extendedTemplatelocation = subDirectory.equals("") ? template.getId() : subDirectory + "/" + template.getId() + ".schem";
            InputStream schematicStream = DimDoors.class.getResourceAsStream(schematicJarDirectory + extendedTemplatelocation);
            File schematicFile = new File(schematicFolder, "/" + extendedTemplatelocation);
            DataInputStream schematicDataStream = null;
            boolean streamOpened = false;
            boolean isCustomFile = false;
            boolean isValidFormat = true;
            if (schematicStream != null) {
                schematicDataStream = new DataInputStream(schematicStream);
                streamOpened = true;
            } else if (schematicFile.exists()) {
                isCustomFile = true;
                try {
                    schematicDataStream = new DataInputStream(new FileInputStream(schematicFile));
                    streamOpened = true;
                }
                catch (FileNotFoundException ex) {
                    DimDoors.log.error("Schematic file " + template.getId() + ".schem did not load correctly from config folder.", (Throwable)ex);
                }
            } else {
                DimDoors.log.error("Schematic \"" + template.getId() + ".schem\" was not found in the jar or config directory.");
            }
            byte[] schematicBytecode = null;
            if (streamOpened) {
                try {
                    schematicBytecode = IOUtils.toByteArray((InputStream)schematicDataStream);
                    schematicDataStream.close();
                }
                catch (IOException ex) {
                    DimDoors.log.error("Schematic file for " + template.getId() + " could not be read into byte array.", (Throwable)ex);
                }
                finally {
                    try {
                        schematicDataStream.close();
                    }
                    catch (IOException ex) {
                        DimDoors.log.error("Error occured while closing schematicDataStream.", (Throwable)ex);
                    }
                }
            }
            if (isCustomFile) {
                Schematic schematic = null;
                try {
                    schematic = Schematic.loadFromNBT(CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(schematicBytecode)));
                }
                catch (Exception ex) {
                    DimDoors.log.error("Schematic file for " + template.getId() + " could not be read as a valid schematic NBT file.", (Throwable)ex);
                    isValidFormat = false;
                }
                if (schematic != null && (schematic.width > (template.getSize() + 1) * 16 || schematic.length > (template.getSize() + 1) * 16)) {
                    DimDoors.log.warn("Schematic " + template.getId() + " was bigger than specified in its json file and therefore wasn't loaded");
                    isValidFormat = false;
                }
            }
            if (!streamOpened || !isValidFormat) continue;
            template.setSchematicBytecode(schematicBytecode);
            validTemplates.add(template);
        }
        return validTemplates;
    }

    private static List<PocketTemplate> getAllValidVariations(JsonObject jsonTemplate) {
        ArrayList<PocketTemplate> pocketTemplates = new ArrayList<PocketTemplate>();
        String group = jsonTemplate.get("group").getAsString();
        JsonArray pockets = jsonTemplate.getAsJsonArray("pockets");
        for (JsonElement pocketElement : pockets) {
            JsonObject pocket = pocketElement.getAsJsonObject();
            int size = pocket.get("size").getAsInt();
            if (!ModConfig.pockets.loadAllSchematics && size > ModConfig.pockets.maxPocketSize) continue;
            String id = pocket.get("id").getAsString();
            String type = pocket.has("type") ? pocket.get("type").getAsString() : null;
            String name = pocket.has("name") ? pocket.get("name").getAsString() : null;
            String author = pocket.has("author") ? pocket.get("author").getAsString() : null;
            int baseWeight = pocket.has("baseWeight") ? pocket.get("baseWeight").getAsInt() : 100;
            pocketTemplates.add(new PocketTemplate(group, id, type, name, author, size, baseWeight));
        }
        return pocketTemplates.stream().sorted(Comparator.comparing(PocketTemplate::getId)).collect(Collectors.toList());
    }

    private void constructNameMap() {
        this.nameMap = new HashMap<String, Map<String, Integer>>();
        String bufferedDirectory = null;
        Map<Object, Object> bufferedMap = null;
        for (PocketTemplate template : this.templates) {
            String dirName = template.getGroup();
            if (dirName != null && dirName.equals(bufferedDirectory)) {
                bufferedMap.put(template.getId(), this.templates.indexOf(template));
                continue;
            }
            bufferedDirectory = dirName;
            if (this.nameMap.containsKey(dirName)) {
                bufferedMap = this.nameMap.get(dirName);
                bufferedMap.put(template.getId(), this.templates.indexOf(template));
                continue;
            }
            bufferedMap = new HashMap<String, Integer>();
            bufferedMap.put(template.getId(), this.templates.indexOf(template));
            this.nameMap.put(dirName, bufferedMap);
        }
    }

    public Set<String> getTemplateGroups() {
        return this.nameMap.keySet();
    }

    public Set<String> getTemplateNames(String group) {
        if (this.nameMap.containsKey(group)) {
            return this.nameMap.get(group).keySet();
        }
        return new HashSet<String>();
    }

    public PocketTemplate getTemplate(String group, String name) {
        Map<String, Integer> groupMap = this.nameMap.get(group);
        if (groupMap == null) {
            return null;
        }
        Integer index = groupMap.get(name);
        if (index == null) {
            return null;
        }
        return this.templates.get(index);
    }

    public PocketTemplate getRandomTemplate(String group, int depth, int maxSize, boolean getLargest) {
        HashMap<PocketTemplate, Float> weightedTemplates = new HashMap<PocketTemplate, Float>();
        int largestSize = 0;
        for (PocketTemplate template : this.templates) {
            if (!template.getGroup().equals(group) || maxSize != -1 && template.getSize() > maxSize) continue;
            if (getLargest && template.getSize() > largestSize) {
                weightedTemplates = new HashMap();
                largestSize = template.getSize();
            }
            weightedTemplates.put(template, Float.valueOf(template.getWeight(depth)));
        }
        if (weightedTemplates.isEmpty()) {
            DimDoors.log.warn("getRandomTemplate failed, no templates matching those criteria were found.");
            return null;
        }
        return (PocketTemplate)MathUtils.weightedRandom(weightedTemplates);
    }

    public PocketTemplate getPersonalPocketTemplate() {
        return this.getRandomTemplate("private", -1, ModConfig.pockets.privatePocketSize, true);
    }

    public PocketTemplate getPublicPocketTemplate() {
        return this.getRandomTemplate("public", -1, ModConfig.pockets.publicPocketSize, true);
    }

    public static void saveSchematic(Schematic schematic, String id) {
        NBTTagCompound schematicNBT = schematic.saveToNBT();
        File saveFolder = new File(DimDoors.getConfigurationFolder(), "/schematics/saved");
        if (!saveFolder.exists()) {
            saveFolder.mkdirs();
        }
        File saveFile = new File(saveFolder.getAbsolutePath() + "/" + id + ".schem");
        try {
            saveFile.getParentFile().mkdirs();
            saveFile.createNewFile();
            DataOutputStream schematicDataStream = new DataOutputStream(new FileOutputStream(saveFile));
            CompressedStreamTools.func_74799_a((NBTTagCompound)schematicNBT, (OutputStream)schematicDataStream);
            schematicDataStream.flush();
            schematicDataStream.close();
        }
        catch (IOException ex) {
            DimDoors.log.error("Something went wrong while saving " + saveFile.getAbsolutePath() + " to disk.", (Throwable)ex);
        }
    }

    public void saveSchematicForEditing(Schematic schematic, String id) {
        Map<String, Integer> savedDungeons;
        SchematicHandler.saveSchematic(schematic, id);
        if (!this.nameMap.containsKey(SAVED_POCKETS_GROUP_NAME)) {
            this.nameMap.put(SAVED_POCKETS_GROUP_NAME, new HashMap());
        }
        if ((savedDungeons = this.nameMap.get(SAVED_POCKETS_GROUP_NAME)).containsKey(id)) {
            this.templates.remove(savedDungeons.remove(id));
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] schematicBytecode = null;
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)schematic.saveToNBT(), (OutputStream)byteStream);
            schematicBytecode = byteStream.toByteArray();
            byteStream.close();
        }
        catch (IOException ex) {
            DimDoors.log.error("Something went wrong while converting schematic " + id + " to bytecode.", (Throwable)ex);
        }
        if (schematicBytecode != null) {
            this.templates.add(new PocketTemplate(SAVED_POCKETS_GROUP_NAME, id, null, null, null, schematic, schematicBytecode, -1, 0));
            this.nameMap.get(SAVED_POCKETS_GROUP_NAME).put(id, this.templates.size() - 1);
        }
    }

    private int getUsage(PocketTemplate template) {
        if (!this.usageMap.containsKey(template)) {
            return -1;
        }
        int index = this.usageMap.get(template);
        if (this.usageList.size() <= index) {
            return -1;
        }
        PocketTemplate listTemplate = this.usageList.get(index).getKey();
        if (listTemplate == template) {
            int usage = this.usageList.get(index).getValue();
            return usage;
        }
        DimDoors.log.warn("Pocket Template usage list is desynched from the usage map, re-sorting and synching now.");
        this.reSortUsages();
        return this.getUsage(template);
    }

    public boolean isUsedOftenEnough(PocketTemplate template) {
        int maxNrOfCachedSchematics = ModConfig.pockets.cachedSchematics;
        int usageRank = this.usageMap.get(template);
        return usageRank < maxNrOfCachedSchematics;
    }

    public void incrementUsage(PocketTemplate template) {
        int newUsage;
        int startIndex;
        if (!this.usageMap.containsKey(template)) {
            this.usageList.add(new AbstractMap.SimpleEntry<Object, Integer>(null, 0));
            startIndex = this.usageList.size() - 1;
            newUsage = 1;
        } else {
            startIndex = this.usageMap.get(template);
            newUsage = this.usageList.get(startIndex).getValue() + 1;
        }
        int insertionIndex = this.findFirstEqualOrLessUsage(newUsage, 0, startIndex);
        for (int i = startIndex; i > insertionIndex; --i) {
            this.usageList.set(i, this.usageList.get(i - 1));
            PocketTemplate currentTemplate = this.usageList.get(i).getKey();
            this.usageMap.put(currentTemplate, i);
        }
        this.usageList.set(insertionIndex, new AbstractMap.SimpleEntry<PocketTemplate, Integer>(template, newUsage));
        this.usageMap.put(template, insertionIndex);
        if (insertionIndex < ModConfig.pockets.cachedSchematics && this.usageList.size() > ModConfig.pockets.cachedSchematics) {
            this.usageList.get(ModConfig.pockets.cachedSchematics).getKey().setSchematic(null);
        }
    }

    private int findFirstEqualOrLessUsage(int usage, int indexMin, int indexMax) {
        if (this.usageList.get(indexMin).getValue() <= usage) {
            return indexMin;
        }
        int halfwayIndex = (indexMin + indexMax) / 2;
        if (this.usageList.get(halfwayIndex).getValue() > usage) {
            return this.findFirstEqualOrLessUsage(usage, halfwayIndex + 1, indexMax);
        }
        return this.findFirstEqualOrLessUsage(usage, indexMin, halfwayIndex);
    }

    private void reSortUsages() {
        this.usageList = this.mergeSortPairArrayByPairValue(this.usageList);
        for (Map.Entry<PocketTemplate, Integer> pair : this.usageList) {
            this.usageMap.put(pair.getKey(), pair.getValue());
        }
        for (Map.Entry<PocketTemplate, Integer> entry : this.usageMap.entrySet()) {
            PocketTemplate template = entry.getKey();
            int index = entry.getValue();
            PocketTemplate template2 = this.usageList.get(index).getKey();
            if (index < this.usageList.size() && template == template2) continue;
            entry.setValue(this.usageList.size());
            this.usageList.add(new AbstractMap.SimpleEntry<PocketTemplate, Integer>(template, 1));
        }
    }

    private List<Map.Entry<PocketTemplate, Integer>> mergeSortPairArrayByPairValue(List<Map.Entry<PocketTemplate, Integer>> input) {
        if (input.size() < 2) {
            return input;
        }
        List<Map.Entry<PocketTemplate, Integer>> a = this.mergeSortPairArrayByPairValue(input.subList(0, input.size() / 2));
        List<Map.Entry<PocketTemplate, Integer>> b = this.mergeSortPairArrayByPairValue(input.subList(input.size() / 2, input.size()));
        return this.mergePairArraysByPairValue(a, b);
    }

    private List<Map.Entry<PocketTemplate, Integer>> mergePairArraysByPairValue(List<Map.Entry<PocketTemplate, Integer>> a, List<Map.Entry<PocketTemplate, Integer>> b) {
        ArrayList<Map.Entry<PocketTemplate, Integer>> output = new ArrayList<Map.Entry<PocketTemplate, Integer>>();
        int aPointer = 0;
        int bPointer = 0;
        while (aPointer < a.size() || bPointer < b.size()) {
            int bValue;
            if (aPointer >= a.size()) {
                output.addAll(b.subList(bPointer, b.size()));
                break;
            }
            if (bPointer >= b.size()) {
                output.addAll(a.subList(aPointer, a.size()));
                break;
            }
            int aValue = a.get(aPointer).getValue();
            if (aValue >= (bValue = b.get(bPointer).getValue().intValue())) {
                output.add(a.get(aPointer));
                ++aPointer;
                continue;
            }
            output.add(b.get(bPointer));
            ++bPointer;
        }
        return output;
    }
}

